/*
 * Copyright (C) 2014 Pablo Campillo-Sanchez <pabcampi@ucm.es>
 *
 * This software has been developed as part of the 
 * SociAAL project directed by Jorge J. Gomez Sanz
 * (http://grasia.fdi.ucm.es/sociaal)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package phat.sensors.accelerometer;

import phat.sensors.SensorData;

/**
 * Representates information generated by a simulated accelerometer 
 * (AccelerometerControl).
 * 
 * @author Pablo
 */
public class AccelerationData implements SensorData {
    private float interval;
    private float x;
    private float y;
    private float z;

    public AccelerationData(float interval, float x, float y, float z) {
        this.interval = interval;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public float getInterval() {
        return interval;
    }

    public float getX() {
        return x;
    }

    public float getY() {
        return y;
    }

    public float getZ() {
        return z;
    }
}
