/*
 * $Id: Runner.java,v 1.6 2009/12/20 17:30:26 oboehm Exp $
 *
 * Copyright (c) 2009 by Oliver Boehm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express orimplied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * (c)reated 30.07.2009 by oliver (ob@oasd.de)
 */

package patterntesting.sample.http;

import org.apache.commons.logging.*;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

import patterntesting.runtime.monitor.ClasspathMonitor;

/**
 * This is a simple wrapper around Jetty as Servlet engine. It is used to start
 * the servlet and JSP samples.
 * {@link "http://docs.codehaus.org/display/JETTY/Embedding+Jetty"}
 *
 * @author oliver
 * @since 30.07.2009
 * @version $Revision: 1.6 $
 */
public final class Runner {

    private static Log log = LogFactory.getLog(Runner.class);
    private final Server jetty;

    /**
     * Instantiates a new runner.
     */
    public Runner() {
        jetty = new Server(4040);
        log.debug(jetty + " created");
    }

    /**
     * Start.
     *
     * @throws Exception the exception
     */
    public void start() throws Exception {
        jetty.setHandler(new WebAppContext("src/main/webapp", "/"));
        jetty.start();
    }

    /**
     * The main method.
     *
     * @param args the arguments
     *
     * @throws Exception the exception
     */
    public static void main(final String[] args) throws Exception {
        ClasspathMonitor.addAsShutdownHook();
        Runner runner = new Runner();
        runner.start();
    }

}
