package patterntesting.sample.http;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

import patterntesting.runtime.monitor.ClasspathMonitor;

/**
 * Servlet implementation class InitServlet
 */
public final class InitServlet extends HttpServlet {

    private static final long serialVersionUID = 20090515L;
    private static final Log log = LogFactoryImpl.getLog(InitServlet.class);

	/**
	 * @see HttpServlet#init(ServletConfig)
	 */
    @Override
	public void init(final ServletConfig config) throws ServletException {
		log.debug("initializing web application...");
		ClasspathMonitor.registerAsMBean();
	}

}
