/*
 * $Id: Bird.java,v 1.6 2009/12/20 17:30:25 oboehm Exp $
 *
 * Copyright (c) 2008 by Oliver Boehm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express orimplied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * (c)reated 22.01.2009 by oliver (ob@oasd.de)
 */
package patterntesting.sample.animal;

/**
 * The Class Bird.
 *
 * @author <a href="boehm@javatux.de">oliver</a>
 * @since 22.01.2009
 * @version $Revision: 1.6 $
 */
public abstract class Bird {

    private final String name;

    /**
     * This is a bad example. Why? You should never call an abstract method
     * inside a constructor.
     * So, if you uncomment "sayHello()" it you'll get a warning message.
     * Also BirdTest.testDuck() will fail.
     *
     * @param name the name
     */
    protected Bird(final String name) {
        this.name = name;
        //sayHello();
    }

    /**
     * Say hello.
     */
    public abstract void sayHello();

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + this.name;
    }

}
