/*
 * $Id: Crash.java,v 1.4 2009/12/20 17:30:25 oboehm Exp $
 *
 * Copyright (c) 2008 by Oliver Boehm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express orimplied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * (c)reated 24.11.2008 by oliver (ob@oasd.de)
 */
package patterntesting.sample;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

import patterntesting.runtime.annotation.GuardInitialization;

/**
 * This class will crash while initializing the static part.
 *
 * @author <a href="boehm@javatux.de">oliver</a>
 * @since 24.11.2008
 * @version $Revision: 1.4 $
 */
@GuardInitialization
public class Crash {

    /** this initialization will crash. */
	protected static final Log log = LogFactoryImpl.getLog((String) null);

	/**
	 * Gets the date.
	 *
	 * @return the date
	 */
	public static Date getDate() {
		return new Date();
	}

}

/**
 * $Log: Crash.java,v $
 * Revision 1.4  2009/12/20 17:30:25  oboehm
 * trailing spaces removed
 *
 * Revision 1.3  2009/10/02 06:51:20  oboehm
 * some common dependencies moved to patterntesting-parent
 * some Javadoc warnings removed
 *
 * Revision 1.2  2008/12/02 21:40:17  oboehm
 * comments updated
 *
 * Revision 1.1  2008/11/24 21:42:31  oboehm
 * simple example how to use @GuardInitialization
 *
 * $Source: /cvsroot/patterntesting/PatternTesting08/patterntesting-samples/src/main/java/patterntesting/sample/Crash.java,v $
 */
