/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model.parameter;

import net.sf.opendse.model.parameter.Parameter;

public class ParameterRange
implements Parameter {
    protected final double value;
    protected final double lb;
    protected final double ub;
    protected final double granularity;

    public ParameterRange(double value, double lb, double ub) {
        this(value, lb, ub, 0.0);
    }

    public ParameterRange(double value, double lb, double ub, double granularity) {
        this.value = value;
        this.lb = lb;
        this.ub = ub;
        this.granularity = granularity;
    }

    public double getLowerBound() {
        return this.lb;
    }

    public double getUpperBound() {
        return this.ub;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public double normalizeValue(double value) {
        if (this.granularity > 0.0) {
            double v = value / this.granularity;
            v = (double)Math.round(v) * this.granularity;
            return v;
        }
        return value;
    }

    public String toString() {
        return this.value + " (" + this.lb + "," + this.ub + "," + this.granularity + ")";
    }
}

