/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import java.util.HashSet;
import java.util.Set;
import net.sf.opendse.model.Architecture;
import net.sf.opendse.model.Link;
import net.sf.opendse.model.Mappings;
import net.sf.opendse.model.Models;
import net.sf.opendse.model.Resource;
import net.sf.opendse.model.Routings;
import net.sf.opendse.model.Specification;
import net.sf.opendse.model.Task;
import org.apache.commons.collections15.Predicate;

public class ValidImplementationPredicate
implements Predicate<Specification> {
    public boolean evaluate(Specification specification) {
        Object application = specification.getApplication();
        Object architecture = specification.getArchitecture();
        Object mappings = specification.getMappings();
        Object routings = specification.getRoutings();
        boolean valid = true;
        for (Task p : Models.filterProcesses(application)) {
            Set set = ((Mappings)mappings).get((Task)p);
            if (set.size() != 1) {
                System.out.println("Process " + p + " is mapped with " + set);
                valid = false;
                continue;
            }
            Task r = set.iterator().next().getTarget();
            if (architecture.containsVertex((Object)r)) continue;
            System.out.println("Process " + p + " is mapped to " + r + " that is not in architecture");
        }
        for (Task c : Models.filterCommunications(application)) {
            Architecture<Resource, Link> routing = ((Routings)routings).get((Task)c);
            for (Resource r : routing.getVertices()) {
                if (architecture.containsVertex((Object)r)) continue;
                System.out.println("Communication " + c + "contains resource " + r + " that is not in the architecture");
                valid = false;
            }
            for (Models.DirectedLink link : Models.getLinks(routing)) {
                Resource r1;
                Link l = link.getLink();
                Resource r0 = link.getSource();
                if (architecture.isSuccessor((Object)r0, (Object)(r1 = link.getDest())) && l.equals(architecture.findEdge((Object)r0, (Object)r1))) continue;
                System.out.println("Communication " + c + "contains link " + l + " that is not in the architecture");
                valid = false;
            }
            for (Task p : application.getNeighbors((Object)c)) {
                Task r = ((Mappings)mappings).get((Task)p).iterator().next().getTarget();
                if (routing.containsVertex(r)) continue;
                System.out.println("Communication " + c + " does not contain target resource " + r + " of process " + p + " in the routing");
                valid = false;
            }
            Task pred = (Task)application.getPredecessors((Object)c).iterator().next();
            Task root = ((Mappings)mappings).get((Task)pred).iterator().next().getTarget();
            HashSet<Task> leaves = new HashSet<Task>();
            for (Task succ : application.getSuccessors((Object)c)) {
                leaves.add(((Mappings)mappings).get((Task)succ).iterator().next().getTarget());
            }
            boolean isTree = true;
            WeakComponentClusterer clusterer = new WeakComponentClusterer();
            Set cluster = clusterer.transform(routing);
            if (cluster.size() != 1) {
                isTree = false;
            }
            for (Resource r : routing.getVertices()) {
                if (routing.getPredecessorCount(r) == 0) {
                    if (!r.equals(root)) {
                        System.out.println("Communication " + c + " originate at " + r + " but predecessor task is mapped to " + root);
                        valid = false;
                    }
                } else if (routing.getPredecessorCount(r) > 1) {
                    isTree = false;
                }
                if (routing.getSuccessorCount(r) != 0 || leaves.contains(r)) continue;
                System.out.println("Communication " + c + " terminates at " + r + " which is not a target of a successor resource");
            }
            if (isTree) continue;
            System.out.println("Communication " + c + " is not routed on valid tree");
            valid = false;
        }
        return valid;
    }
}

