/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import java.util.Set;
import net.sf.opendse.model.Application;
import net.sf.opendse.model.Architecture;
import net.sf.opendse.model.Attributes;
import net.sf.opendse.model.Dependency;
import net.sf.opendse.model.IAttributes;
import net.sf.opendse.model.ICommunication;
import net.sf.opendse.model.Link;
import net.sf.opendse.model.Mappings;
import net.sf.opendse.model.Resource;
import net.sf.opendse.model.Routings;
import net.sf.opendse.model.Task;
import net.sf.opendse.model.parameter.Parameter;

public class Specification
implements IAttributes {
    protected Architecture<?, ?> architecture = null;
    protected Application<?, ?> application = null;
    protected Mappings<?, ?> mappings = null;
    protected Routings<?, ?, ?> routings = null;
    protected Attributes attributes = new Attributes();

    public Specification(Application<?, ?> application, Architecture<?, ?> architecture, Mappings<?, ?> mappings) {
        this(application, architecture, mappings, Specification.fill(application, architecture));
    }

    protected static Routings<?, ?, ?> fill(Application<?, ?> application, Architecture<?, ?> architecture) {
        Routings routings = new Routings();
        Architecture<?, ?> arch = architecture;
        for (Task task : application) {
            if (!(task instanceof ICommunication)) continue;
            Architecture routing = new Architecture();
            for (Resource resource : architecture.getVertices()) {
                routing.addVertex(new Resource(resource));
            }
            for (Link link : architecture.getEdges()) {
                routing.addEdge(new Link(link), arch.getEndpoints(link), arch.getEdgeType(link));
            }
            routings.set(task, routing);
        }
        return routings;
    }

    public Specification(Application<?, ?> application, Architecture<?, ?> architecture, Mappings<?, ?> mappings, Routings<?, ?, ?> routings) {
        this.architecture = architecture;
        this.application = application;
        this.mappings = mappings;
        this.routings = routings;
    }

    public <A extends Architecture<Resource, Link>> A getArchitecture() {
        return (A)this.architecture;
    }

    public <A extends Application<Task, Dependency>> A getApplication() {
        return (A)this.application;
    }

    public <M extends Mappings<Task, Resource>> M getMappings() {
        return (M)this.mappings;
    }

    public <R extends Routings<Task, Resource, Link>> R getRoutings() {
        return (R)this.routings;
    }

    @Override
    public void setAttribute(String identifier, Object object) {
        this.attributes.setAttribute(identifier, object);
    }

    @Override
    public <O> O getAttribute(String identifier) {
        return this.attributes.getAttribute(identifier);
    }

    @Override
    public Parameter getAttributeParameter(String identifier) {
        return this.attributes.getAttributeParameter(identifier);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public boolean isDefined(String identifier) {
        return this.attributes.isDefined(identifier);
    }
}

