/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.opendse.model.Application;
import net.sf.opendse.model.Architecture;
import net.sf.opendse.model.Attributes;
import net.sf.opendse.model.Dependency;
import net.sf.opendse.model.Element;
import net.sf.opendse.model.Function;
import net.sf.opendse.model.Graph;
import net.sf.opendse.model.IAttributes;
import net.sf.opendse.model.ICommunication;
import net.sf.opendse.model.Link;
import net.sf.opendse.model.Mapping;
import net.sf.opendse.model.Mappings;
import net.sf.opendse.model.Node;
import net.sf.opendse.model.Resource;
import net.sf.opendse.model.Routings;
import net.sf.opendse.model.Specification;
import net.sf.opendse.model.Task;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.iterators.FilterIterator;

public class Models {
    protected static IsCommunicationPredicate isCommunicationPredicate = new IsCommunicationPredicate();
    protected static IsProcessPredicate isProcessPredicate = new IsProcessPredicate();

    public static Iterable<Task> filterCommunications(final Iterable<Task> iterable) {
        return new Iterable<Task>(){

            @Override
            public Iterator<Task> iterator() {
                return new OnlyCommunicationIterator(iterable.iterator());
            }
        };
    }

    public static Iterable<Task> filterProcesses(final Iterable<Task> iterable) {
        return new Iterable<Task>(){

            @Override
            public Iterator<Task> iterator() {
                return new OnlyProcessIterator(iterable.iterator());
            }
        };
    }

    public static boolean isProcess(Task task) {
        return isProcessPredicate.evaluate(task);
    }

    public static boolean isCommunication(Task task) {
        return isCommunicationPredicate.evaluate(task);
    }

    public static List<DirectedLink> getOutLinks(Architecture<Resource, Link> architecture, Resource r0) {
        assert (architecture != null);
        assert (r0 != null);
        assert (architecture.containsVertex(r0));
        ArrayList<DirectedLink> list = new ArrayList<DirectedLink>();
        for (Link link : architecture.getOutEdges(r0)) {
            Resource r1 = (Resource)architecture.getOpposite(r0, link);
            list.add(new DirectedLink(link, r0, r1));
        }
        return list;
    }

    public static List<DirectedLink> getInLinks(Architecture<Resource, Link> architecture, Resource r0) {
        ArrayList<DirectedLink> list = new ArrayList<DirectedLink>();
        for (Link link : architecture.getInEdges(r0)) {
            Resource r1 = (Resource)architecture.getOpposite(r0, link);
            list.add(new DirectedLink(link, r1, r0));
        }
        return list;
    }

    public static List<DirectedLink> getLinks(Architecture<Resource, Link> architecture) {
        ArrayList<DirectedLink> list = new ArrayList<DirectedLink>();
        for (Resource r0 : architecture.getVertices()) {
            list.addAll(Models.getOutLinks(architecture, r0));
        }
        return list;
    }

    public static List<DirectedLink> getLinks(Architecture<Resource, Link> architecture, Link link) {
        ArrayList<DirectedLink> list = new ArrayList<DirectedLink>();
        Pair pair = architecture.getEndpoints(link);
        Resource r0 = (Resource)pair.getFirst();
        Resource r1 = (Resource)pair.getSecond();
        if (architecture.getEdgeType(link) == EdgeType.UNDIRECTED) {
            list.add(new DirectedLink(link, r0, r1));
            list.add(new DirectedLink(link, r1, r0));
        } else {
            list.add(new DirectedLink(link, r0, r1));
        }
        return list;
    }

    public static Map<String, Element> getElementsMap(Specification specification) {
        HashMap<String, Element> elements = new HashMap<String, Element>();
        Object application = specification.getApplication();
        Object architecture = specification.getArchitecture();
        Object mappings = specification.getMappings();
        for (Resource resource : architecture) {
            elements.put(resource.getId(), resource);
        }
        for (Link link : architecture.getEdges()) {
            elements.put(link.getId(), link);
        }
        for (Task task : application) {
            elements.put(task.getId(), task);
        }
        for (Dependency dependency : application.getEdges()) {
            elements.put(dependency.getId(), dependency);
        }
        for (Mapping mapping : mappings) {
            elements.put(mapping.getId(), mapping);
        }
        return elements;
    }

    public static Set<Element> getElements(Specification specification) {
        Object application = specification.getApplication();
        Object architecture = specification.getArchitecture();
        Object mappings = specification.getMappings();
        HashSet<Element> elements = new HashSet<Element>();
        elements.addAll(application.getVertices());
        elements.addAll(application.getEdges());
        elements.addAll(architecture.getVertices());
        elements.addAll(architecture.getEdges());
        elements.addAll(((Mappings)mappings).getAll());
        return elements;
    }

    public static <E extends Element> Iterable<E> filterType(final Iterable<E> iterable, final String ... types) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new FilterIterator(iterable.iterator(), new Predicate<E>(){

                    public boolean evaluate(E e) {
                        for (String type : types) {
                            if (!type.equals(((Element)e).getType())) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        };
    }

    public static Specification copy(Specification specification) {
        Node dest;
        Node source;
        Pair endpoints;
        Object sArchitecture = specification.getArchitecture();
        Object sApplication = specification.getApplication();
        Object sMappings = specification.getMappings();
        Object sRoutings = specification.getRoutings();
        Architecture iArchitecture = new Architecture();
        Application iApplication = new Application();
        Mappings iMappings = new Mappings();
        Routings iRoutings = new Routings();
        for (Resource resource : sArchitecture) {
            iArchitecture.addVertex((Resource)Models.copy(resource));
        }
        for (Link link : sArchitecture.getEdges()) {
            endpoints = sArchitecture.getEndpoints((Object)link);
            source = (Resource)iArchitecture.getVertex((Node)endpoints.getFirst());
            dest = (Resource)iArchitecture.getVertex((Node)endpoints.getSecond());
            iArchitecture.addEdge((Link)Models.copy(link), source, dest, sArchitecture.getEdgeType((Object)link));
        }
        for (Task task : sApplication) {
            iApplication.addVertex((Task)Models.copy(task));
        }
        for (Dependency dependency : sApplication.getEdges()) {
            endpoints = sApplication.getEndpoints((Object)dependency);
            source = (Task)iApplication.getVertex((Node)endpoints.getFirst());
            dest = (Task)iApplication.getVertex(((Graph)sApplication).getVertex((Node)((Node)endpoints.getSecond())));
            iApplication.addEdge((Dependency)Models.copy(dependency), source, dest, sApplication.getEdgeType((Object)dependency));
        }
        for (Function function : iApplication.getFunctions()) {
            Task t = (Task)function.iterator().next();
            Models.setAttributes(function, ((Application)sApplication).getFunction((Task)t).getAttributes());
        }
        for (Mapping mapping : sMappings) {
            Object copy = Models.copy(mapping);
            ((Mapping)copy).setSource((Task)((Task)iApplication.getVertex(mapping.getSource())));
            ((Mapping)copy).setTarget((Resource)((Resource)iArchitecture.getVertex(mapping.getTarget())));
            iMappings.add(copy);
        }
        for (Task task : Models.filterCommunications(sApplication)) {
            Architecture sRouting = ((Routings)sRoutings).get((Task)task);
            Architecture iRouting = new Architecture();
            for (Resource r : sRouting) {
                r = iArchitecture.getVertex(r);
                iRouting.addVertex((Resource)Models.copy(r));
            }
            for (Link l : sRouting.getEdges()) {
                Pair endpoints2 = sRouting.getEndpoints(l);
                Resource r0 = (Resource)iRouting.getVertex((Node)endpoints2.getFirst());
                Resource r1 = (Resource)iRouting.getVertex((Node)endpoints2.getSecond());
                iRouting.addEdge((Link)Models.copy(l), r0, r1, sRouting.getEdgeType(l));
            }
            iRoutings.set(iApplication.getVertex(task), iRouting);
        }
        return new Specification(iApplication, iArchitecture, iMappings, iRoutings);
    }

    public static <E extends Element> E copy(Element element) {
        try {
            Constructor<?> cstr = element.getClass().getConstructor(Element.class);
            Element copy = (Element)cstr.newInstance(element);
            return (E)copy;
        }
        catch (Exception e) {
            throw new RuntimeException("could not copy element " + element, e);
        }
    }

    public static <M extends Mapping<?, ?>> M copy(Mapping<?, ?> mapping) {
        try {
            Constructor<?> cstr = mapping.getClass().getConstructor(Element.class, Task.class, Resource.class);
            Element copy = (Element)cstr.newInstance(mapping, mapping.getSource(), mapping.getTarget());
            return (M)((Mapping)copy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setAttributes(IAttributes e, Attributes attributes) {
        for (String name : attributes.keySet()) {
            e.setAttribute(name, attributes.get(name));
        }
    }

    public static Specification clone(Specification specification) {
        Application iApplication = Models.clone(specification.getApplication());
        Architecture iArchitecture = Models.clone(specification.getArchitecture());
        Mappings iMappings = new Mappings();
        Routings iRoutings = new Routings();
        for (Object m : specification.getMappings()) {
            iMappings.add(m);
        }
        Object sRoutings = specification.getRoutings();
        for (Task c : Models.filterCommunications(specification.getApplication())) {
            Architecture sRouting = ((Routings)sRoutings).get((Task)c);
            iRoutings.set(c, sRouting);
        }
        Specification clone = new Specification(iApplication, iArchitecture, iMappings, iRoutings);
        return clone;
    }

    public static <T extends Task, D extends Dependency> Application<T, D> clone(Application<T, D> sApplication) {
        Application iApplication = new Application();
        for (Task task : sApplication) {
            iApplication.addVertex(task);
        }
        for (Dependency dependency : sApplication.getEdges()) {
            iApplication.addEdge(dependency, sApplication.getEndpoints(dependency), sApplication.getEdgeType(dependency));
        }
        for (Function function : iApplication.getFunctions()) {
            Task t = (Task)function.iterator().next();
            Models.setAttributes(function, sApplication.getFunction(t).getAttributes());
        }
        return iApplication;
    }

    public static <R extends Resource, L extends Link> Architecture<R, L> clone(Architecture<R, L> sArchitecture) {
        Architecture iArchitecture = new Architecture();
        for (Resource r : sArchitecture) {
            iArchitecture.addVertex(r);
        }
        for (Link l : sArchitecture.getEdges()) {
            iArchitecture.addEdge(l, sArchitecture.getEndpoints(l), sArchitecture.getEdgeType(l));
        }
        return iArchitecture;
    }

    public static void filterByResources(Specification specification, Collection<Resource> resources) {
        HashSet<Resource> deleteResources = new HashSet<Resource>();
        for (Resource rd : specification.getArchitecture()) {
            if (resources.contains(rd)) continue;
            deleteResources.add(rd);
        }
        HashSet deleteMappings = new HashSet();
        HashSet<Task> deleteTasks = new HashSet<Task>();
        for (Task task : specification.getApplication()) {
            if (Models.isCommunication(task)) {
                HashSet<Resource> deleteRoutingResources = new HashSet<Resource>();
                Architecture routing = ((Routings)specification.getRoutings()).get((Task)task);
                for (Resource r : routing) {
                    if (resources.contains(r)) continue;
                    deleteRoutingResources.add(r);
                }
                for (Resource r : deleteRoutingResources) {
                    routing.removeVertex(r);
                }
                deleteTasks.add(task);
                continue;
            }
            if (!Models.isProcess(task)) continue;
            boolean keep = false;
            for (Mapping mapping : ((Mappings)specification.getMappings()).get((Task)task)) {
                if (resources.contains(mapping.getTarget())) {
                    keep = true;
                    continue;
                }
                deleteMappings.add(mapping);
            }
            if (keep) continue;
            deleteTasks.add(task);
        }
        ((Mappings)specification.getMappings()).removeAll(deleteMappings);
        ((Graph)specification.getApplication()).removeVertices(deleteTasks);
        ((Graph)specification.getArchitecture()).removeVertices(deleteResources);
    }

    public static void filter(Specification specification, Collection<Function<Task, Dependency>> functions) {
        HashSet<Task> keep = new HashSet<Task>();
        for (Function<Task, Dependency> function : functions) {
            for (Task task : function) {
                keep.add(task);
            }
        }
        HashSet<Task> removeTasks = new HashSet<Task>();
        HashSet<Mapping> removeMappings = new HashSet<Mapping>();
        for (Task task : specification.getApplication()) {
            if (keep.contains(task)) continue;
            removeTasks.add(task);
        }
        for (Mapping mapping : specification.getMappings()) {
            if (keep.contains(mapping.getSource())) continue;
            removeMappings.add(mapping);
        }
        for (Task task : removeTasks) {
            if (Models.isCommunication(task)) {
                ((Routings)specification.getRoutings()).remove((Task)task);
            }
            ((Application)specification.getApplication()).removeVertex((Task)task);
        }
        for (Mapping mapping : removeMappings) {
            ((Mappings)specification.getMappings()).remove(mapping);
        }
        HashSet<Object> keepResources = new HashSet<Object>();
        HashSet<Resource> removeResources = new HashSet<Resource>();
        for (Mapping mapping : specification.getMappings()) {
            keepResources.add(mapping.getTarget());
        }
        for (Architecture architecture : ((Routings)specification.getRoutings()).getRoutings()) {
            for (Resource resouce : architecture) {
                keepResources.add(resouce);
            }
        }
        for (Resource resource : specification.getArchitecture()) {
            if (keepResources.contains(resource)) continue;
            removeResources.add(resource);
        }
        for (Resource resource : removeResources) {
            specification.getArchitecture().removeVertex((Object)resource);
        }
        for (Architecture architecture : ((Routings)specification.getRoutings()).getRoutings()) {
            ArrayList<Resource> remove = new ArrayList<Resource>();
            for (Resource resource : architecture) {
                if (specification.getArchitecture().containsVertex((Object)resource)) continue;
                remove.add(resource);
            }
            for (Resource resource : remove) {
                architecture.removeVertex(resource);
            }
        }
    }

    public static void filterByFunctionName(Specification specification, Collection<String> functions) {
        HashSet<Function<Task, Dependency>> funcs = new HashSet<Function<Task, Dependency>>();
        for (String f : functions) {
            funcs.add(((Application)specification.getApplication()).getFunction(f));
        }
        Models.filter(specification, funcs);
    }

    public static void filterByFunctionName(Specification specification, String ... functions) {
        HashSet<String> funcs = new HashSet<String>();
        for (String s : functions) {
            funcs.add(s);
        }
        Models.filterByFunctionName(specification, funcs);
    }

    public static class DirectedLink {
        final Link l;
        final Resource r0;
        final Resource r1;

        public DirectedLink(Link l, Resource r0, Resource r1) {
            this.l = l;
            this.r0 = r0;
            this.r1 = r1;
        }

        public Link getLink() {
            return this.l;
        }

        public Resource getSource() {
            return this.r0;
        }

        public Resource getDest() {
            return this.r1;
        }
    }

    protected static class OnlyProcessIterator
    extends FilterIterator<Task> {
        public OnlyProcessIterator(Iterator<Task> iterator) {
            super(iterator, (Predicate)new IsProcessPredicate());
        }
    }

    protected static class IsProcessPredicate
    implements Predicate<Task> {
        protected IsProcessPredicate() {
        }

        public boolean evaluate(Task task) {
            return !(task instanceof ICommunication);
        }
    }

    protected static class OnlyCommunicationIterator
    extends FilterIterator<Task> {
        public OnlyCommunicationIterator(Iterator<Task> iterator) {
            super(iterator, (Predicate)new IsCommunicationPredicate());
        }
    }

    protected static class IsCommunicationPredicate
    implements Predicate<Task> {
        protected IsCommunicationPredicate() {
        }

        public boolean evaluate(Task task) {
            return task instanceof ICommunication;
        }
    }
}

