/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.opendse.model.Attributes;
import net.sf.opendse.model.Dependency;
import net.sf.opendse.model.Element;
import net.sf.opendse.model.Function;
import net.sf.opendse.model.Graph;
import net.sf.opendse.model.Task;

public class Application<T extends Task, D extends Dependency>
extends Graph<T, D> {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Attributes> fmap = new HashMap<String, Attributes>();

    public void add(Function<T, D> function) {
        for (Task t : function) {
            if (!this.containsVertex(t)) continue;
            throw new RuntimeException("Application already contains " + t);
        }
        for (Dependency d : function.getEdges()) {
            if (!this.containsEdge(d)) continue;
            throw new RuntimeException("Application already contains " + d);
        }
        for (Task t : function) {
            this.addVertex(t);
        }
        for (Dependency d : function.getEdges()) {
            this.addEdge((D)d, (T)function.getEndpoints(d), (T)function.getEdgeType(d));
        }
        Task t = (Task)function.iterator().next();
        this.fmap.put(t.getId(), function.getAttributes());
    }

    public boolean removeVertex(T t) {
        if (this.fmap.containsKey(((Element)t).getId())) {
            Attributes attributes = this.fmap.remove(((Element)t).getId());
            if (this.getNeighborCount(t) > 0) {
                Task next = (Task)this.getNeighbors(t).iterator().next();
                this.fmap.put(next.getId(), attributes);
            }
        }
        return super.removeVertex(t);
    }

    public Function<T, D> getFunction(T task) {
        Set<T> tasks = this.getReachable(task);
        return this.buildFunction(tasks);
    }

    public Function<T, D> getFunction(D dependency) {
        return this.getFunction((D)((Task)this.getSource(dependency)));
    }

    public Function<T, D> getFunction(String id) {
        for (Map.Entry<String, Attributes> entry : this.fmap.entrySet()) {
            if (!id.equals(entry.getValue().getAttribute("ID"))) continue;
            return this.getFunction((D)((Task)this.getVertex(entry.getKey())));
        }
        return null;
    }

    public Set<Function<T, D>> getFunctions() {
        WeakComponentClusterer wcc = new WeakComponentClusterer();
        Set cluster = wcc.transform((edu.uci.ics.jung.graph.Graph)this);
        HashSet<Function<T, D>> functions = new HashSet<Function<T, D>>();
        for (Set tasks : cluster) {
            Function<T, D> function = this.buildFunction(tasks);
            functions.add(function);
        }
        return functions;
    }

    protected String nextFunctionId() {
        String id;
        boolean exists;
        int i = 0;
        do {
            id = "func" + i;
            ++i;
            exists = false;
            for (Attributes attributes : this.fmap.values()) {
                if (!id.equals(attributes.getAttribute("ID"))) continue;
                exists = true;
            }
        } while (exists);
        return id;
    }

    protected Function<T, D> buildFunction(Set<T> tasks) {
        Attributes attributes = this.getAttributes(tasks);
        if (attributes.getAttribute("ID") == null) {
            attributes.setAttribute("ID", this.nextFunctionId());
        }
        Function function = new Function(attributes);
        for (Task t : tasks) {
            function.addVertex(t);
            Collection outEdges = this.getOutEdges(t);
            for (Dependency d : outEdges) {
                Task dest = (Task)this.getDest(d);
                function.addEdge(d, t, dest);
            }
        }
        return function;
    }

    protected Attributes getAttributes(Set<T> tasks) {
        Task t2;
        assert (!tasks.isEmpty());
        for (Task t2 : tasks) {
            if (!this.fmap.containsKey(t2.getId())) continue;
            return this.fmap.get(t2.getId());
        }
        Attributes attributes = new Attributes();
        t2 = (Task)tasks.iterator().next();
        this.fmap.put(t2.getId(), attributes);
        return attributes;
    }

    protected Set<T> getReachable(T task) {
        HashSet reachable = new HashSet();
        HashSet<T> current = new HashSet<T>();
        current.add(task);
        while (!current.isEmpty()) {
            reachable.addAll(current);
            HashSet next = new HashSet();
            for (Task t : current) {
                HashSet neighbors = new HashSet(this.getNeighbors(t));
                neighbors.removeAll(reachable);
                next.addAll(neighbors);
            }
            current = next;
        }
        return reachable;
    }

    public boolean addEdge(D dependency, Collection<? extends T> vertices) {
        return super.addEdge(dependency, vertices, EdgeType.DIRECTED);
    }

    public boolean addEdge(D dependency, Pair<? extends T> endpoints) {
        return super.addEdge(dependency, endpoints, EdgeType.DIRECTED);
    }

    public boolean addEdge(D dependency, T v1, T v2) {
        return super.addEdge(dependency, v1, v2, EdgeType.DIRECTED);
    }
}

