/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import edu.uci.ics.jung.graph.SparseMultigraph;
import java.util.Collection;
import java.util.Iterator;
import net.sf.opendse.model.Edge;
import net.sf.opendse.model.Element;
import net.sf.opendse.model.Node;

public class Graph<V extends Node, E extends Edge>
extends SparseMultigraph<V, E>
implements Iterable<V> {
    private static final long serialVersionUID = 1L;

    @Override
    public Iterator<V> iterator() {
        return this.getVertices().iterator();
    }

    public V getVertex(V v) {
        return this.getVertex(((Element)v).getId());
    }

    public E getEdge(E e) {
        return this.getEdge(((Element)e).getId());
    }

    public V getVertex(String id) {
        for (Node v : this.getVertices()) {
            if (!v.getId().equals(id)) continue;
            return (V)v;
        }
        return null;
    }

    public E getEdge(String id) {
        for (Edge e : this.getEdges()) {
            if (!e.getId().equals(id)) continue;
            return (E)e;
        }
        return null;
    }

    public boolean removeVertices(Collection<V> vertices) {
        boolean b = false;
        for (Node vertex : vertices) {
            b |= this.removeVertex(vertex);
        }
        return b;
    }
}

