/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.opendse.model.Mapping;
import net.sf.opendse.model.Resource;
import net.sf.opendse.model.Task;
import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.bag.HashBag;
import org.apache.commons.collections15.functors.InstantiateFactory;
import org.apache.commons.collections15.map.LazyMap;

public class Mappings<T extends Task, R extends Resource>
implements Iterable<Mapping<T, R>> {
    protected Set<Mapping<T, R>> mappings = new HashSet<Mapping<T, R>>();
    protected Map<T, Set<Mapping<T, R>>> taskMappings = LazyMap.decorate(new HashMap(), (Factory)new InstantiateFactory(HashSet.class));
    protected Map<R, Set<Mapping<T, R>>> resourceMappings = LazyMap.decorate(new HashMap(), (Factory)new InstantiateFactory(HashSet.class));
    protected Map<T, Bag<R>> targets = LazyMap.decorate(new HashMap(), (Factory)new InstantiateFactory(HashBag.class));
    protected Map<R, Bag<T>> sources = LazyMap.decorate(new HashMap(), (Factory)new InstantiateFactory(HashBag.class));

    public void add(Mapping<T, R> mapping) {
        this.mappings.add(mapping);
        T source = mapping.getSource();
        R target = mapping.getTarget();
        Set<Mapping<T, R>> s0 = this.taskMappings.get(source);
        Set<Mapping<T, R>> s1 = this.resourceMappings.get(target);
        s0.add(mapping);
        s1.add(mapping);
        Bag<R> ts = this.targets.get(source);
        Bag<T> ss = this.sources.get(target);
        ts.add(target);
        ss.add(source);
    }

    public boolean remove(Mapping<T, R> mapping) {
        boolean exist = this.mappings.remove(mapping);
        if (exist) {
            T source = mapping.getSource();
            R target = mapping.getTarget();
            Set<Mapping<T, R>> s0 = this.taskMappings.get(source);
            Set<Mapping<T, R>> s1 = this.resourceMappings.get(target);
            s0.remove(mapping);
            s1.remove(mapping);
            Bag<R> ts = this.targets.get(source);
            Bag<T> ss = this.sources.get(target);
            ts.remove(target);
            ss.remove(source);
        }
        return exist;
    }

    public boolean removeAll(Collection<Mapping<T, R>> mappings) {
        boolean b = false;
        for (Mapping<T, R> mapping : mappings) {
            b |= this.remove(mapping);
        }
        return b;
    }

    @Override
    public Iterator<Mapping<T, R>> iterator() {
        return this.mappings.iterator();
    }

    public int size() {
        return this.mappings.size();
    }

    public Set<Mapping<T, R>> get(T source) {
        return Collections.unmodifiableSet(this.taskMappings.get(source));
    }

    public Set<R> getTargets(T source) {
        return this.targets.get(source).uniqueSet();
    }

    public Set<Mapping<T, R>> get(R target) {
        return Collections.unmodifiableSet(this.resourceMappings.get(target));
    }

    public Set<T> getSources(R target) {
        return this.sources.get(target).uniqueSet();
    }

    public Set<Mapping<T, R>> get(T source, R target) {
        HashSet<Mapping<T, T>> set = new HashSet<Mapping<T, T>>(this.get((R)source));
        set.retainAll(this.get(target));
        return Collections.unmodifiableSet(set);
    }

    public Set<Mapping<T, R>> getAll() {
        return Collections.unmodifiableSet(this.mappings);
    }
}

