/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model.parameter;

import net.sf.opendse.model.Element;
import net.sf.opendse.model.parameter.Parameter;

public class ParameterReference
implements Comparable<ParameterReference> {
    protected final String id;
    protected final String attribute;
    protected final Parameter parameter;

    public ParameterReference(Element element, String attribute) {
        this(element.getId(), attribute, element.getAttributeParameter(attribute));
    }

    public ParameterReference(String id, String attribute, Parameter parameter) {
        this.id = id;
        this.attribute = attribute;
        this.parameter = parameter;
    }

    public String getId() {
        return this.id;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterReference other = (ParameterReference)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ParameterReference o) {
        int v = this.id.compareTo(o.id);
        if (v != 0) {
            return v;
        }
        v = this.attribute.compareTo(o.attribute);
        return v;
    }

    public String toString() {
        return "[id=" + this.id + ", attribute=" + this.attribute + "]";
    }
}

