/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.model;

import java.util.HashSet;
import java.util.Set;
import net.sf.opendse.model.Attributes;
import net.sf.opendse.model.IAttributes;
import net.sf.opendse.model.parameter.Parameter;

public class Element
implements IAttributes {
    public static String TYPE = "TYPE";
    protected final Attributes attributes = new Attributes();
    protected Element parent = null;
    protected String id = null;

    public Element(String id) {
        this.id = id;
    }

    public Element(Element parent) {
        this(parent.getId());
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element element) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent element has already been defined.");
        }
        this.parent = element;
    }

    @Override
    public <O> O getAttribute(String identifier) {
        if (this.attributes.getAttributes().containsKey(identifier)) {
            return this.attributes.getAttribute(identifier);
        }
        if (this.parent != null) {
            return this.parent.getAttribute(identifier);
        }
        return null;
    }

    @Override
    public boolean isDefined(String identifier) {
        if (this.attributes.isDefined(identifier)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isDefined(identifier);
        }
        return false;
    }

    @Override
    public Attributes getAttributes() {
        Attributes map = new Attributes();
        if (this.parent != null) {
            map.putAll(this.parent.getAttributes());
        }
        map.putAll(this.attributes.getAttributes());
        return map;
    }

    public Attributes getLocalAttributes() {
        return this.attributes;
    }

    public Set<String> getLocalAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public void setAttribute(String identifier, Object object) {
        this.attributes.setAttribute(identifier, object);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public Parameter getAttributeParameter(String identifier) {
        Parameter parameter = this.attributes.getAttributeParameter(identifier);
        Object attribute = this.attributes.getAttribute(identifier);
        if (parameter != null) {
            return parameter;
        }
        if (parameter == null && attribute != null) {
            return null;
        }
        if (this.getParent() != null) {
            return this.getParent().getAttributeParameter(identifier);
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.parent != null) {
            names.addAll(this.parent.getAttributeNames());
        }
        names.addAll(this.attributes.getAttributeNames());
        return names;
    }

    public String getType() {
        return (String)this.getAttribute(TYPE);
    }

    public void setType(String type) {
        this.setAttribute(TYPE, type);
    }
}

