/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.sf.opendse.generator.Generator;
import net.sf.opendse.generator.IdProvider;
import net.sf.opendse.model.Application;
import net.sf.opendse.model.Communication;
import net.sf.opendse.model.Dependency;
import net.sf.opendse.model.ICommunication;
import net.sf.opendse.model.Task;

public class ApplicationGenerator
extends Generator {
    protected IdProvider taskId;
    protected IdProvider commId;
    protected IdProvider dependencyId;

    public ApplicationGenerator() {
        this(System.currentTimeMillis());
    }

    public ApplicationGenerator(long seed) {
        this(seed, new IdProvider("p"), new IdProvider("c"), new IdProvider("d"));
    }

    public ApplicationGenerator(long seed, IdProvider taskId, IdProvider commId, IdProvider dependencyId) {
        super(new Random(seed));
        this.taskId = taskId;
        this.commId = commId;
        this.dependencyId = dependencyId;
    }

    public Application<Task, Dependency> generate(int x, int id, int od) {
        Application application = new Application();
        Task task = new Task(this.taskId.next());
        application.addVertex((Object)task);
        while (application.getVertexCount() < x) {
            Dependency dependency;
            if (this.random.nextBoolean()) {
                ArrayList<Task> candidates = new ArrayList<Task>();
                for (Task task2 : application) {
                    if (application.getSuccessorCount((Object)task2) >= od) continue;
                    candidates.add(task2);
                }
                int q = candidates.size();
                assert (q > 0);
                int o = Math.min(candidates.size(), Math.min(application.getVertexCount(), id));
                int z = this.rand(0, o);
                if (z <= 0) continue;
                while (candidates.size() > z) {
                    candidates.remove(this.rand(candidates));
                }
                Task task3 = new Task(this.taskId.next());
                for (Task c : candidates) {
                    dependency = new Dependency(this.dependencyId.next());
                    application.addEdge(dependency, c, task3);
                }
                continue;
            }
            int minDegree = Integer.MAX_VALUE;
            ArrayList<Task> candidates = new ArrayList<Task>();
            for (Task task4 : application) {
                int d = application.getOutEdges((Object)task4).size();
                if (d < minDegree) {
                    minDegree = d;
                    candidates.clear();
                }
                if (d != minDegree) continue;
                candidates.add(task4);
            }
            if (minDegree >= od) continue;
            Task p = (Task)this.rand(candidates);
            int r = od - application.getSuccessorCount((Object)p);
            int y = this.rand(0, r);
            for (int i = 0; i < y; ++i) {
                Task task5 = new Task(this.taskId.next());
                dependency = new Dependency(this.dependencyId.next());
                application.addEdge(dependency, p, task5);
            }
        }
        return application;
    }

    public void insertCommunication(Application<Task, Dependency> application, int min, int max) {
        HashSet tasks = new HashSet(application.getVertices());
        for (Task task : tasks) {
            ArrayList edges = new ArrayList(application.getOutEdges((Object)task));
            for (Dependency edge : new ArrayList(edges)) {
                if (!(application.getDest((Object)edge) instanceof ICommunication)) continue;
                edges.remove(edge);
            }
            while (!edges.isEmpty()) {
                int x = this.rand(min, max);
                ArrayList<Dependency> targets = new ArrayList<Dependency>();
                while (!edges.isEmpty() && targets.size() < x) {
                    Dependency edge = (Dependency)this.rand(edges);
                    edges.remove(edge);
                    targets.add(edge);
                }
                Communication comm = new Communication(this.commId.next());
                Dependency e = new Dependency(this.dependencyId.next());
                application.addEdge(e, task, (Task)comm);
                for (Dependency edge : targets) {
                    Task t = (Task)application.getDest((Object)edge);
                    application.removeEdge((Object)edge);
                    application.addEdge(edge, (Task)comm, t);
                }
            }
        }
    }

    public Application<Task, Dependency> merge(Collection<Application<Task, Dependency>> applications) {
        Application application = new Application();
        for (Application<Task, Dependency> appl : applications) {
            for (Task task : appl.getVertices()) {
                application.addVertex((Object)task);
            }
            for (Dependency dependency : appl.getEdges()) {
                application.addEdge((Object)dependency, appl.getEndpoints((Object)dependency), appl.getEdgeType((Object)dependency));
            }
        }
        return application;
    }

    public Application<Task, Dependency> merge(Application<Task, Dependency> ... applications) {
        List<Application<Task, Dependency>> apps = Arrays.asList(applications);
        return this.merge(apps);
    }
}

