/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.sf.opendse.generator.Generator;
import net.sf.opendse.generator.IdProvider;
import net.sf.opendse.model.Application;
import net.sf.opendse.model.Architecture;
import net.sf.opendse.model.Dependency;
import net.sf.opendse.model.Link;
import net.sf.opendse.model.Mapping;
import net.sf.opendse.model.Mappings;
import net.sf.opendse.model.Models;
import net.sf.opendse.model.Resource;
import net.sf.opendse.model.Task;

public class MappingGenerator
extends Generator {
    protected final IdProvider mappingId;

    public MappingGenerator() {
        this(System.currentTimeMillis());
    }

    public MappingGenerator(long seed) {
        this(seed, new IdProvider("m"));
    }

    public MappingGenerator(long seed, IdProvider mappingId) {
        super(new Random(seed));
        this.mappingId = mappingId;
    }

    public Mappings<Task, Resource> create(Application<Task, Dependency> application, Architecture<Resource, Link> architecture, int min, int max) {
        return this.create(application, architecture.getVertices(), min, max);
    }

    public Mappings<Task, Resource> create(Application<Task, Dependency> application, Collection<Resource> resources, int min, int max) {
        Mappings mappings = new Mappings();
        ArrayList tasks = new ArrayList(application.getVertices());
        ArrayList<Resource> res = new ArrayList<Resource>(new HashSet<Resource>(resources));
        for (Task task : Models.filterProcesses(tasks)) {
            int x = this.rand(min, max);
            ArrayList<Resource> targets = new ArrayList<Resource>();
            while (targets.size() < x) {
                Resource target = this.rand(res);
                targets.add(target);
            }
            for (Resource target : targets) {
                Mapping mapping = new Mapping(this.mappingId.next(), task, target);
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public void annotateAttribute(Mappings<Task, Resource> mappings, String attribute, int min, int max) {
        for (Mapping mapping : mappings.getAll()) {
            mapping.setAttribute(attribute, (Object)this.rand(min, max));
        }
    }
}

