/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.sf.opendse.generator.Generator;
import net.sf.opendse.generator.IdProvider;
import net.sf.opendse.model.Architecture;
import net.sf.opendse.model.Link;
import net.sf.opendse.model.Resource;

public class ArchitectureGenerator
extends Generator {
    protected final IdProvider resourceId;
    protected final IdProvider linkId;

    public ArchitectureGenerator() {
        this(System.currentTimeMillis());
    }

    public ArchitectureGenerator(long seed) {
        this(seed, new IdProvider("r"), new IdProvider("l"));
    }

    public ArchitectureGenerator(long seed, IdProvider resourceId, IdProvider linkId) {
        super(new Random(seed));
        this.resourceId = resourceId;
        this.linkId = linkId;
    }

    public Architecture<Resource, Link> getStar(int depth, int branches) {
        Architecture architecture = new Architecture();
        Resource center = new Resource(this.resourceId.next());
        architecture.addVertex((Object)center);
        for (int i = 0; i < branches; ++i) {
            Resource current = center;
            for (int j = 0; j < depth; ++j) {
                Resource next = new Resource(this.resourceId.next());
                Link edge = new Link(this.linkId.next());
                architecture.addEdge((Object)edge, (Object)current, (Object)next);
                current = next;
            }
        }
        return architecture;
    }

    public Architecture<Resource, Link> merge(Collection<Architecture<Resource, Link>> architectures) {
        Architecture architecture = new Architecture();
        for (Architecture<Resource, Link> arch : architectures) {
            for (Resource resource : arch.getVertices()) {
                architecture.addVertex((Object)resource);
            }
            for (Link link : arch.getEdges()) {
                architecture.addEdge((Object)link, arch.getEndpoints((Object)link), arch.getEdgeType((Object)link));
            }
        }
        return architecture;
    }

    public Architecture<Resource, Link> merge(Architecture<Resource, Link> ... architectures) {
        List<Architecture<Resource, Link>> archs = Arrays.asList(architectures);
        return this.merge(archs);
    }
}

