/*
 * Decompiled with CFR 0.152.
 */
package net.sf.opendse.generator;

import java.util.List;
import java.util.Random;
import net.sf.opendse.model.Edge;
import net.sf.opendse.model.Graph;
import net.sf.opendse.model.Models;
import net.sf.opendse.model.Node;
import net.sf.opendse.model.Task;

public abstract class Generator {
    protected final Random random;

    public Generator(Random random) {
        this.random = random;
    }

    public int rand(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    public <V> V rand(List<V> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    public void annotateAttribute(Graph<?, ?> graph, String attribute, int min, int max, Type type) {
        if (type == Type.NODE || type == Type.PROCESS || type == Type.COMMUNICATION || type == Type.ELEMENT) {
            for (Node n : graph.getVertices()) {
                if (type == Type.PROCESS && n instanceof Task && Models.isProcess((Task)((Task)n))) {
                    n.setAttribute(attribute, (Object)this.rand(min, max));
                    continue;
                }
                if (type == Type.COMMUNICATION && n instanceof Task && Models.isCommunication((Task)((Task)n))) {
                    n.setAttribute(attribute, (Object)this.rand(min, max));
                    continue;
                }
                n.setAttribute(attribute, (Object)this.rand(min, max));
            }
        }
        if (type == Type.EDGE || type == Type.ELEMENT) {
            for (Edge e : graph.getEdges()) {
                e.setAttribute(attribute, (Object)this.rand(min, max));
            }
        }
    }

    public static enum Type {
        NODE,
        PROCESS,
        COMMUNICATION,
        EDGE,
        ELEMENT;

    }
}

