/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.support;

import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.openas2.support.FileMonitorListener;

public class FileMonitor
implements Runnable {
    private List<FileMonitorListener> listeners = new LinkedList<FileMonitorListener>();
    @Nonnull
    private Date lastModified;
    @Nonnull
    private File file;

    public FileMonitor(@Nonnull File file, FileMonitorListener listener) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " doesn't exist.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " isn't a file.");
        }
        this.file = file;
        this.lastModified = this.getLastModifiedFromFile();
        this.listeners.add(listener);
    }

    public void addListener(FileMonitorListener listener) {
        this.listeners.add(listener);
    }

    private boolean isModified() {
        Date currentModified = this.getLastModifiedFromFile();
        return currentModified.after(this.lastModified);
    }

    @Nonnull
    private Date getLastModifiedFromFile() {
        return new Date(this.file.lastModified());
    }

    private void notifyListeners(int eventID) {
        for (FileMonitorListener listener : this.listeners) {
            listener.onFileEvent(this.file, eventID);
        }
    }

    @Override
    public void run() {
        if (this.isModified()) {
            this.lastModified = this.getLastModifiedFromFile();
            this.notifyListeners(1);
        }
    }
}

