/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.processor.receiver.PollingModule;
import org.openas2.util.IOUtil;

public abstract class DirectoryPollingModule
extends PollingModule {
    public static final String PARAM_OUTBOX_DIRECTORY = "outboxdir";
    public static final String PARAM_FILE_EXTENSION_FILTER = "fileextensionfilter";
    public static final String PARAM_FILE_EXTENSION_EXCLUDE_FILTER = "fileextensionexcludefilter";
    private Map<String, Long> trackedFiles;
    private String outboxDir;
    private String errorDir;
    private String sentDir = null;
    private List<String> allowExtensions;
    private List<String> excludeExtensions;
    private Log logger = LogFactory.getLog((String)DirectoryPollingModule.class.getSimpleName());

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        try {
            this.outboxDir = this.getParameter(PARAM_OUTBOX_DIRECTORY, true);
            IOUtil.getDirectoryFile(this.outboxDir);
            String pendingInfoFolder = this.getSession().getProcessor().getParameters().get("pendingmdninfo");
            IOUtil.getDirectoryFile(pendingInfoFolder);
            String pendingFolder = this.getSession().getProcessor().getParameters().get("pendingmdn");
            IOUtil.getDirectoryFile(pendingFolder);
            String allowExtensionFilter = this.getParameter(PARAM_FILE_EXTENSION_FILTER, "");
            String excludeExtensionFilter = this.getParameter(PARAM_FILE_EXTENSION_EXCLUDE_FILTER, "");
            this.allowExtensions = allowExtensionFilter == null || allowExtensionFilter.length() < 1 ? new ArrayList<String>() : Arrays.asList(allowExtensionFilter.split("\\s*,\\s*"));
            this.excludeExtensions = excludeExtensionFilter == null || excludeExtensionFilter.length() < 1 ? new ArrayList<String>() : Arrays.asList(excludeExtensionFilter.split("\\s*,\\s*"));
        }
        catch (IOException e) {
            throw new OpenAS2Exception("Failed to initialise directory poller.", e);
        }
    }

    @Override
    public boolean healthcheck(List<String> failures) {
        try {
            IOUtil.getDirectoryFile(this.outboxDir);
        }
        catch (IOException e) {
            failures.add(this.getClass().getSimpleName() + " - Polling directory is not accessible: " + this.outboxDir);
            return false;
        }
        return true;
    }

    @Override
    public void poll() {
        try {
            this.updateTracking();
            this.scanDirectory(this.outboxDir);
        }
        catch (OpenAS2Exception oae) {
            oae.terminate();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unexpected error occurred polling directory for files to send: " + this.outboxDir), (Throwable)e);
        }
    }

    protected void scanDirectory(String directory) throws IOException, InvalidParameterException {
        File dir = IOUtil.getDirectoryFile(directory);
        File[] files = IOUtil.getFiles(dir, this.allowExtensions, this.excludeExtensions);
        if (files == null) {
            throw new InvalidParameterException("Error getting list of files in directory", this, PARAM_OUTBOX_DIRECTORY, dir.getAbsolutePath());
        }
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File currentFile = files[i];
                if (!this.checkFile(currentFile)) continue;
                this.trackFile(currentFile);
            }
        }
    }

    protected boolean checkFile(File file) {
        block5: {
            if (file.exists() && file.isFile()) {
                try {
                    FileOutputStream fOut = new FileOutputStream(file, true);
                    fOut.close();
                    return true;
                }
                catch (IOException ioe) {
                    if (!this.logger.isDebugEnabled()) break block5;
                    try {
                        this.logger.debug((Object)("Directory poller detected a non-writable file and will be ignored: " + file.getCanonicalPath()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    private void trackFile(File file) {
        String filePath;
        Map<String, Long> trackedFiles = this.getTrackedFiles();
        if (trackedFiles.get(filePath = file.getAbsolutePath()) == null) {
            trackedFiles.put(filePath, file.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTracking() {
        Map<String, Long> trackedFiles = this.getTrackedFiles();
        HashMap<String, Long> trackedFilesClone = new HashMap<String, Long>(trackedFiles);
        for (Map.Entry fileEntry : trackedFilesClone.entrySet()) {
            File file = new File((String)fileEntry.getKey());
            long fileLength = (Long)fileEntry.getValue();
            if (!this.checkFile(file)) {
                trackedFiles.remove(fileEntry.getKey());
                continue;
            }
            long newLength = file.length();
            if (newLength != fileLength) {
                trackedFiles.put((String)fileEntry.getKey(), newLength);
                continue;
            }
            try {
                this.processFile(file);
            }
            catch (OpenAS2Exception e) {
                e.terminate();
                try {
                    IOUtil.handleError(file, this.errorDir);
                }
                catch (OpenAS2Exception e1) {
                    this.logger.error((Object)("Error handling file error for file: " + file.getAbsolutePath()), (Throwable)e1);
                    this.forceStop(e1);
                    return;
                }
            }
            finally {
                trackedFiles.remove(fileEntry.getKey());
            }
        }
    }

    @Override
    protected abstract Message createMessage();

    protected void processFile(File file) throws OpenAS2Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("processing " + file.getAbsolutePath()));
        }
        try (FileInputStream in = new FileInputStream(file);){
            this.processDocument(in, file.getName());
            try {
                IOUtil.deleteFile(file);
            }
            catch (IOException e) {
                throw new OpenAS2Exception("Failed to delete file handed off for processing:" + file.getAbsolutePath(), e);
            }
        }
        catch (IOException e) {
            throw new OpenAS2Exception("Failed to process file:" + file.getAbsolutePath(), e);
        }
    }

    private Map<String, Long> getTrackedFiles() {
        if (this.trackedFiles == null) {
            this.trackedFiles = new HashMap<String, Long>();
        }
        return this.trackedFiles;
    }
}

