/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.util.Map;
import java.util.StringTokenizer;
import org.openas2.BaseComponent;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.logging.DefaultFormatter;
import org.openas2.logging.Formatter;
import org.openas2.logging.Level;
import org.openas2.logging.Logger;
import org.openas2.message.Message;

public abstract class BaseLogger
extends BaseComponent
implements Logger {
    public static final String PARAM_EXCEPTIONS = "exceptions";
    public static final String PARAM_SHOW = "show";
    public static final String VALUE_SHOW_ALL = "all";
    public static final String VALUE_SHOW_TERMINATED = "terminated";
    public static final String VALUE_SHOW_EXCEPTIONS = "exceptions";
    public static final String VALUE_SHOW_INFO = "info";
    private Formatter formatter;
    private boolean logExceptionTrace = true;

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.logExceptionTrace = "true".equalsIgnoreCase(parameters.getOrDefault("log_exception_trace", "true"));
    }

    public boolean isLogExceptionTrace() {
        return this.logExceptionTrace;
    }

    public void setLogExceptionTrace(boolean logExceptionTrace) {
        this.logExceptionTrace = logExceptionTrace;
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new DefaultFormatter();
        }
        return this.formatter;
    }

    @Override
    public void log(Throwable t, Level level, boolean terminated) {
        if (t instanceof OpenAS2Exception) {
            OpenAS2Exception e = (OpenAS2Exception)t;
            if (this.isLogging(e)) {
                if (terminated && this.isShowing(VALUE_SHOW_TERMINATED)) {
                    this.doLog(e, terminated);
                } else if (!terminated && this.isShowing("exceptions")) {
                    this.doLog(e, terminated);
                }
            }
        } else if (t != null) {
            this.doLog(t, terminated);
        }
    }

    @Override
    public void log(Level level, String msgText, Message message, Throwable t) {
        this.doLog(level, msgText, message);
        if (t != null && this.isLogExceptionTrace()) {
            this.doLog(t, false);
        }
    }

    protected boolean isLogging(OpenAS2Exception exception) {
        block4: {
            try {
                String exceptionName = exception.getClass().getName();
                String exceptions = this.getParameter("exceptions", false);
                if (exceptions != null) {
                    StringTokenizer exceptionTokens = new StringTokenizer(exceptions, ",", false);
                    while (exceptionTokens.hasMoreTokens()) {
                        if (!exceptionTokens.nextToken().equals(exceptionName)) continue;
                        return true;
                    }
                    break block4;
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected abstract String getShowDefaults();

    protected boolean isShowing(String value) {
        try {
            String showOptions = this.getParameter(PARAM_SHOW, false);
            if (showOptions == null) {
                showOptions = this.getShowDefaults();
            }
            if (showOptions.indexOf(value) >= 0 || showOptions.indexOf(VALUE_SHOW_ALL) >= 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    protected abstract void doLog(Throwable var1, boolean var2);

    protected abstract void doLog(Level var1, String var2, Message var3);
}

