/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.message.InvalidMessageException;
import org.openas2.util.ProfilerStub;
import org.openas2.util.Properties;

public class IOUtil {
    private static final Log logger = LogFactory.getLog((String)IOUtil.class.getSimpleName());

    public static OutputStreamWriter getOutPutStreamWriter(String target, boolean createDirectories, String charsetName) throws IOException {
        if (charsetName == null) {
            charsetName = StandardCharsets.UTF_8.name();
        }
        Charset charSet = Charset.forName(charsetName);
        return new OutputStreamWriter((OutputStream)IOUtil.getFileOutPutStream(target, createDirectories), charSet);
    }

    public static FileOutputStream getFileOutPutStream(String target, boolean createDirectories) throws IOException {
        File dir;
        File tgtFile = new File(target);
        if (createDirectories && (dir = tgtFile.getParentFile()) != null && !dir.exists()) {
            IOUtil.createDirs(dir);
        }
        return new FileOutputStream(tgtFile);
    }

    public static File getDirectoryFile(String directory) throws IOException {
        File dir = new File(directory);
        if (!dir.exists()) {
            IOUtil.createDirs(dir);
        }
        return dir;
    }

    public static String getTransferRate(int bytes, ProfilerStub stub) {
        StringBuffer buf = new StringBuffer();
        buf.append(bytes).append(" bytes in ");
        buf.append(stub.getCombined()).append(" at ");
        long time = stub.getDifference();
        if (time != 0L) {
            double stime = (double)time / 1000.0;
            long rate = Math.round((double)bytes / stime);
            buf.append(IOUtil.getTransferRate(rate));
        } else {
            buf.append(IOUtil.getTransferRate(bytes));
        }
        return buf.toString();
    }

    private static String getTransferRate(long bytesPerSecond) {
        StringBuilder buf = new StringBuilder();
        long kbytesPerSecond = bytesPerSecond / 1024L;
        if (bytesPerSecond < 1024L) {
            buf.append(bytesPerSecond).append(" Bps");
        } else if (kbytesPerSecond < 1024L) {
            buf.append(kbytesPerSecond).append(".").append(bytesPerSecond % 1024L).append(" KBps");
        } else {
            buf.append(kbytesPerSecond / 1024L).append(".").append(kbytesPerSecond % 1024L).append(" MBps");
        }
        return buf.toString();
    }

    public static File getUnique(File dir, String filename) {
        filename = IOUtil.cleanFilename(filename);
        return new File(dir, filename + "." + UUID.randomUUID());
    }

    public static String cleanFilename(String filename) {
        String reservedFilenameChars = Properties.getProperty("reservedFilenameCharacters", "<>:\"|?*");
        if (reservedFilenameChars != null && reservedFilenameChars.length() > 0) {
            String srchReplStr = reservedFilenameChars.replaceAll("\\[", "\\[").replaceAll("\\]", "\\]");
            filename = reservedFilenameChars.contains(":") && filename.matches("^[a-zA-Z]{1}:.*") ? filename.substring(0, 2) + filename.substring(2).replaceAll("[" + srchReplStr + "]", "") : filename.replaceAll("[" + srchReplStr + "]", "");
        }
        return filename;
    }

    public static void handleError(File file, String errorDirectory) throws OpenAS2Exception {
        File destFile = null;
        try {
            File errorDir = IOUtil.getDirectoryFile(errorDirectory);
            destFile = new File(errorDir, file.getName());
            destFile = IOUtil.moveFile(file, destFile, false);
        }
        catch (IOException ioe) {
            InvalidMessageException im = new InvalidMessageException("Failed to move " + file.getAbsolutePath() + " to error directory " + destFile.getAbsolutePath());
            im.initCause(ioe);
            throw im;
        }
        InvalidMessageException imMoved = new InvalidMessageException("Moved " + file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        imMoved.terminate();
    }

    public static File moveFile(File src, File dest, boolean overwrite) throws IOException {
        if (!overwrite && dest.exists()) {
            dest = IOUtil.getUnique(dest.getAbsoluteFile().getParentFile(), dest.getName());
        }
        IOException moveFail = null;
        try {
            IOUtil.moveFileAtomic(src, dest, overwrite);
            return dest;
        }
        catch (IOException e) {
            moveFail = e;
            boolean destDirCreated = false;
            File destParent = dest.getParentFile();
            if (destParent != null && !destParent.exists()) {
                IOUtil.createDirs(destParent);
                destDirCreated = true;
            }
            if (destDirCreated) {
                try {
                    IOUtil.moveFileAtomic(src, dest, overwrite);
                    return dest;
                }
                catch (IOException e2) {
                    moveFail = e2;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Atomic move for " + src + " failed with [" + moveFail + "], trying alternatives to move to " + dest));
            }
            if (overwrite) {
                FileUtils.copyFile((File)src, (File)dest);
                IOUtil.deleteFile(src);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Moved file using copy-delete from " + src + " to " + dest));
                }
            } else {
                FileUtils.moveFile((File)src, (File)dest);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Moved file using rename from " + src + " to " + dest));
                }
            }
            return dest;
        }
    }

    private static void moveFileAtomic(File src, File dest, boolean overwrite) throws IOException {
        if (overwrite) {
            Files.move(src.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.move(src.toPath(), dest.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Moved file atomically from " + src + " to " + dest));
        }
    }

    private static synchronized void createDirs(File dir) throws IOException {
        if (dir != null) {
            if (dir.mkdirs()) {
                logger.info((Object)("Created directory " + dir));
            } else if (!dir.isDirectory()) {
                throw new IOException("Directory '" + dir + "' cannot be created");
            }
        }
    }

    public static void deleteFile(File f) throws IOException {
        block4: {
            try {
                Files.delete(f.toPath());
            }
            catch (NoSuchFileException fileGone) {
                return;
            }
            catch (IOException deleteFail) {
                if (f.delete() || !f.exists()) break block4;
                throw deleteFail;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted file " + f));
        }
    }

    public static File[] getFiles(File dir, List<String> allowedExtensions, List<String> excludedExtensions) {
        final List<String> allowExtensions = allowedExtensions;
        final List<String> excludeExtensions = excludedExtensions;
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String extension = name.substring(name.lastIndexOf(".") + 1, name.length());
                boolean isAllowed = true;
                if (!allowExtensions.isEmpty() && !(isAllowed = allowExtensions.contains(extension))) {
                    return false;
                }
                if (!excludeExtensions.isEmpty()) {
                    isAllowed = !excludeExtensions.contains(extension);
                }
                return isAllowed;
            }
        });
    }
}

