/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.msgtracking;

import java.util.HashMap;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.processor.BaseProcessorModule;
import org.openas2.processor.msgtracking.TrackingModule;

public abstract class BaseMsgTrackingModule
extends BaseProcessorModule
implements TrackingModule {
    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        Map<String, String> fields = this.buildMap(msg, options);
        this.persist(msg, fields);
    }

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        return action.equals(this.getModuleAction());
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
    }

    protected abstract String getModuleAction();

    protected abstract void persist(Message var1, Map<String, String> var2);

    protected Map<String, String> buildMap(Message msg, Map<Object, Object> options) {
        String sender;
        HashMap<String, String> map = new HashMap<String, String>();
        String msgId = msg.getMessageID();
        MessageMDN mdn = msg.getMDN();
        if (mdn != null) {
            map.put("mdn_id", mdn.getMessageID());
            map.put("mdn_response", msg.getMDN().getText());
            String originalMsgId = mdn.getAttribute("ORIGINAL_MESSAGE_ID");
            if (originalMsgId != null && !msgId.equals(originalMsgId)) {
                msgId = originalMsgId;
            }
        }
        map.put("msg_id", msgId);
        map.put("prior_msg_id", msg.getAttribute("prior_msg_id"));
        String direction = (String)options.get("direction");
        map.put("direction", direction == null ? "SEND" : direction);
        String isResend = (String)options.get("is_resend");
        if (isResend != null) {
            map.put("is_resend", isResend);
            map.put("resend_count", (String)options.get("retries"));
        }
        if ((sender = msg.getPartnership().getSenderID("as2_id")) == null) {
            sender = mdn.getPartnership().getSenderID("as2_id");
        }
        map.put("sender_id", sender);
        String receiver = msg.getPartnership().getReceiverID("as2_id");
        if (receiver == null) {
            receiver = mdn.getPartnership().getReceiverID("as2_id");
        }
        map.put("receiver_id", receiver);
        map.put("status", msg.getStatus());
        String state = (String)options.get("state");
        map.put("state", state);
        map.put("state_msg", Message.STATE_MSGS.get(state));
        map.put("signature_algorithm", msg.getPartnership().getAttribute("sign"));
        map.put("encryption_algorithm", msg.getPartnership().getAttribute("encrypt"));
        map.put("compression", msg.getPartnership().getAttribute("compression"));
        map.put("file_name", msg.getPayloadFilename());
        map.put("sent_file_name", msg.getAttribute("filename"));
        map.put("content_type", msg.getContentType());
        map.put("content_transfer_encoding", msg.getHeader("Content-Transfer-Encoding"));
        map.put("mdn_mode", msg.getPartnership().isAsyncMDN() ? "ASYNC" : "SYNC");
        return map;
    }

    public static class FIELDS {
        public static final String MSG_ID = "msg_id";
        public static final String PRIOR_MSG_ID = "prior_msg_id";
        public static final String MDN_ID = "mdn_id";
        public static final String DIRECTION = "direction";
        public static final String IS_RESEND = "is_resend";
        public static final String RESEND_COUNT = "resend_count";
        public static final String SENDER_ID = "sender_id";
        public static final String RECEIVER_ID = "receiver_id";
        public static final String STATUS = "status";
        public static final String STATE = "state";
        public static final String SIGNATURE_ALGORITHM = "signature_algorithm";
        public static final String ENCRYPTION_ALGORITHM = "encryption_algorithm";
        public static final String COMPRESSION = "compression";
        public static final String FILE_NAME = "file_name";
        public static final String SENT_FILE_NAME = "sent_file_name";
        public static final String CONTENT_TYPE = "content_type";
        public static final String CONTENT_TRANSFER_ENCODING = "content_transfer_encoding";
        public static final String MDN_MODE = "mdn_mode";
        public static final String MDN_RESPONSE = "mdn_response";
        public static final String STATE_MSG = "state_msg";
        public static final String CREATE_DT = "create_dt";
        public static final String UPDATE_DT = "update_dt";
    }
}

