/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app.cert;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.app.cert.AliasedCertCommand;
import org.openas2.cert.AliasedCertificateFactory;
import org.openas2.cmd.CommandResult;

public class ListCertCommand
extends AliasedCertCommand {
    @Override
    public String getDefaultDescription() {
        return "List all certificate aliases in the current certificate store";
    }

    @Override
    public String getDefaultName() {
        return "list";
    }

    @Override
    public String getDefaultUsage() {
        return "list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(AliasedCertificateFactory certFx, Object[] params) throws OpenAS2Exception {
        AliasedCertificateFactory aliasedCertificateFactory = certFx;
        synchronized (aliasedCertificateFactory) {
            Map<String, X509Certificate> certs = certFx.getCertificates();
            Iterator<Map.Entry<String, X509Certificate>> certIt = certs.entrySet().iterator();
            CommandResult cmdRes = new CommandResult("OK");
            while (certIt.hasNext()) {
                Map.Entry<String, X509Certificate> currentCert = certIt.next();
                cmdRes.getResults().add(currentCert.getKey().toString());
            }
            if (cmdRes.getResults().size() == 0) {
                cmdRes.getResults().add("No certificates available");
            }
            return cmdRes;
        }
    }
}

