/*
 * Decompiled with CFR 0.152.
 */
package org.openas2;

import java.util.HashMap;
import java.util.Map;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import org.openas2.Component;
import org.openas2.ComponentNotFoundException;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.cert.CertificateFactory;
import org.openas2.partner.PartnershipFactory;
import org.openas2.processor.Processor;
import org.openas2.util.Properties;

public abstract class BaseSession
implements Session {
    private Map<String, Component> components = new HashMap<String, Component>();
    private String baseDirectory;

    public BaseSession() throws OpenAS2Exception {
        this.init();
    }

    @Override
    public void start() throws OpenAS2Exception {
        this.getProcessor().startActiveModules();
    }

    @Override
    public void stop() throws Exception {
        for (Component component : this.components.values()) {
            component.destroy();
        }
    }

    @Override
    public CertificateFactory getCertificateFactory() throws ComponentNotFoundException {
        return (CertificateFactory)this.getComponent("certificatefactory");
    }

    void setComponent(String componentID, Component comp) {
        Map<String, Component> objects = this.getComponents();
        objects.put(componentID, comp);
    }

    @Override
    public Component getComponent(String componentID) throws ComponentNotFoundException {
        Map<String, Component> comps = this.getComponents();
        Component comp = comps.get(componentID);
        if (comp == null) {
            throw new ComponentNotFoundException(componentID);
        }
        return comp;
    }

    @Override
    public Map<String, Component> getComponents() {
        return this.components;
    }

    @Override
    public PartnershipFactory getPartnershipFactory() throws ComponentNotFoundException {
        return (PartnershipFactory)this.getComponent("partnershipfactory");
    }

    @Override
    public Processor getProcessor() throws ComponentNotFoundException {
        return (Processor)this.getComponent("processor");
    }

    protected void init() throws OpenAS2Exception {
        this.initJavaMail();
    }

    private void initJavaMail() throws OpenAS2Exception {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("message/disposition-notification;; x-java-content-handler=org.openas2.lib.util.javamail.DispositionDataContentHandler");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
    }

    @Override
    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    void setBaseDirectory(String dir) {
        this.baseDirectory = dir;
        Properties.setProperty(Properties.APP_BASE_DIR_PROP, this.baseDirectory);
    }
}

