/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class CheckCertificate {
    public static int CheckCertStore(String host, int port, String targetKeyStore, String keyStorePwd) throws Exception {
        if (keyStorePwd == null || keyStorePwd.length() < 1) {
            keyStorePwd = "changeit";
        }
        char[] passphrase = keyStorePwd.toCharArray();
        File file = new File(targetKeyStore);
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            if (!dir.isDirectory()) {
                dir = new File(System.getProperty("java.home") + SEP + "jre" + SEP + "lib" + SEP + "security");
            }
            if (!dir.isDirectory()) {
                throw new Exception("The JSSE folder could not be identified. Please check that JSSE is installed.");
            }
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        SSLSocket socket = null;
        try {
            socket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port);
        }
        catch (Exception e) {
            throw new Exception("\nSOCKET FAIL ::: Reason: " + e + "\n");
        }
        SSLParameters sslParms = socket.getSSLParameters();
        String[] protocols = sslParms.getProtocols();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultX509TM = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultX509TM = (X509TrustManager)tm;
            break;
        }
        SavingTrustManager tm = new SavingTrustManager(defaultX509TM);
        String lastExceptionMsg = "";
        for (int i = 0; i < protocols.length; ++i) {
            SSLContext context;
            try {
                context = SSLContext.getInstance(protocols[i]);
            }
            catch (NoSuchAlgorithmException e1) {
                lastExceptionMsg = e1.getMessage();
                continue;
            }
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            try {
                socket = (SSLSocket)factory.createSocket(host, port);
                break;
            }
            catch (IOException io) {
                lastExceptionMsg = io.getMessage();
                continue;
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        if (socket == null) {
            throw new Exception("Failed to connect to remote system:  " + lastExceptionMsg);
        }
        try {
            socket.setSoTimeout(10000);
            socket.startHandshake();
            socket.close();
            System.out.println("No errors, certificate is already trusted");
            return 0;
        }
        catch (SSLHandshakeException e) {
            boolean startNdx;
            System.out.println("\nException caught starting SSL handshake so set up a local certificate store with trust chain....\n\n");
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                throw new Exception("Could not obtain server certificate chain");
            }
            System.out.println("Number of certificates in chain: " + chain.length);
            boolean bl = startNdx = chain.length != 1;
            if (!startNdx) {
                CheckCertificate.findClosestMatchTrustedCert(ks, chain[0]);
                System.out.println("\n\nThe root certificate is not trusted so storing it locally... ");
            }
            for (int k = 0; k < chain.length; ++k) {
                X509Certificate cert = chain[k];
                String alias = host + "-" + (k + 1);
                ks.setCertificateEntry(alias, cert);
                FileOutputStream out = new FileOutputStream(targetKeyStore);
                ks.store(out, passphrase);
                ((OutputStream)out).close();
                System.out.println("Installed certificate as trusted: " + cert.getIssuerDN() + "::" + cert.getSigAlgName());
            }
            return 0;
        }
    }

    private static void findClosestMatchTrustedCert(KeyStore ks, X509Certificate rootCert) {
        PKIXParameters params;
        try {
            params = new PKIXParameters(ks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String rootCertDN = rootCert.getIssuerDN().getName();
        String org = CheckCertificate.getDNField("O", rootCertDN).toLowerCase();
        String org1StWord = org.replaceAll("(\\S*)[^$]*", "$1").toLowerCase();
        System.out.println("Looking for matches to root certificate DN:\n\t" + rootCertDN + "\n\t\tReference certificate signing algorthim: " + rootCert.getSigAlgName() + "\n\n\tTrusted certificate(s) most closely matching \"O\" field of root certificate DN:");
        Iterator<TrustAnchor> it = params.getTrustAnchors().iterator();
        boolean found = false;
        while (it.hasNext()) {
            TrustAnchor ta = it.next();
            X509Certificate cert = ta.getTrustedCert();
            String dn = cert.getIssuerDN().getName();
            String lcDN = dn.toLowerCase();
            if (!lcDN.contains(org) && !lcDN.contains(org1StWord)) continue;
            found = true;
            System.out.println("\t\tTrusted certificate DN:\n\t\t" + dn + "\n\t\tTrusted certificate signing algorthim: " + cert.getSigAlgName());
        }
        if (!found) {
            System.out.println("\n\t\t\tNo matching certificates found");
        }
    }

    private static String getDNField(String dnFld, String dn) {
        return dn.contains(" " + dnFld + "=\"") ? dn.replaceAll(".* " + dnFld + "=\"([^\"]*)\",[^$]*", "$1") : dn.replaceAll(".* " + dnFld + "=([^,]*),[^$]*", "$1");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            System.out.println("Usage: java CheckCertChain <host name>[:port] <localKeystoreFile> [passphrase]");
            return;
        }
        String[] c = args[0].split(":");
        String host = c[0];
        int port = c.length == 1 ? 443 : Integer.parseInt(c[1]);
        String keyStoreFile = args[1];
        String passphrase = args.length == 2 ? "changeit" : args[2];
        CheckCertificate.CheckCertStore(host, port, keyStoreFile, passphrase);
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.tm.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

