/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.logging.BaseLogger;
import org.openas2.logging.Level;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.CompositeParameters;
import org.openas2.params.ExceptionParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageMDNParameters;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;

public class EmailLogger
extends BaseLogger {
    public static final String PARAM_FROM_DISPLAY = "from_display";
    public static final String PARAM_FROM = "from";
    public static final String PARAM_TO = "to";
    public static final String PARAM_SMTPSERVER = "smtpserver";
    public static final String PARAM_SMTPPORT = "smtpport";
    public static final String PARAM_SMTPPROTOCOL = "smtpprotocol";
    public static final String PARAM_SUBJECT = "subject";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_BODYTEMPLATE = "bodytemplate";
    private Properties props = new Properties();
    private boolean isDebugOn = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.getParameter(PARAM_FROM, true);
        this.getParameter(PARAM_TO, true);
        this.getParameter(PARAM_SMTPSERVER, true);
        this.props.putAll((Map<?, ?>)System.getProperties());
        String filename = this.getParameter("javax.mail.properties.file", false);
        if (filename != null) {
            ParameterParser parser = this.createParser();
            filename = ParameterParser.parse(filename, parser);
            FileInputStream in = null;
            try {
                in = new FileInputStream(filename);
                this.props.load(in);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found for attribute javax.mail.properties.file: " + filename);
                e.printStackTrace();
            }
            catch (IOException e) {
                System.out.println("File for attribute javax.mail.properties.file cannot be accessed: " + filename);
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void doLog(Level level, String msgText, org.openas2.message.Message as2Msg) {
        if (level != Level.ERROR) {
            return;
        }
        this.isDebugOn = "true".equalsIgnoreCase(System.getProperty("maillogger.debug.enabled", "false"));
        try {
            String subject = this.getParameter(PARAM_SUBJECT, false);
            if (subject == null) {
                subject = this.getSubject(null);
            }
            subject = this.parseText(null, false, subject);
            this.sendMessage(subject, this.getFormatter().format(level, msgText + (as2Msg == null ? "" : as2Msg.getLogMsgID())));
        }
        catch (Exception e) {
            System.out.println("Failed to send email: " + Log.getExceptionMsg(e));
            e.printStackTrace();
        }
    }

    @Override
    protected void doLog(Throwable t, boolean terminated) {
        this.isDebugOn = "true".equalsIgnoreCase(System.getProperty("maillogger.debug.enabled", "false"));
        try {
            String subject = this.getParameter(PARAM_SUBJECT, false);
            if (subject == null) {
                subject = this.getSubject(t);
            }
            subject = this.parseText(t, terminated, subject);
            StringBuffer body = new StringBuffer();
            if (this.getParameter(PARAM_BODY, false) != null) {
                body.append(this.parseText(t, terminated, this.getParameter(PARAM_BODY, false)));
            }
            body.append(System.getProperty("line.separator"));
            if (this.getParameter(PARAM_BODYTEMPLATE, false) != null) {
                body.append(this.parseText(t, terminated, this.getTemplateText()));
            } else {
                body.append(this.getFormatter().format(t, terminated));
            }
            this.sendMessage(subject, body.toString());
        }
        catch (Exception e) {
            System.out.println("Failed to send email: " + Log.getExceptionMsg(e));
            e.printStackTrace();
        }
    }

    @Override
    protected String getShowDefaults() {
        return "terminated";
    }

    protected String getSubject(Level level, String msg) throws OpenAS2Exception {
        if (msg == null) {
            throw new OpenAS2Exception("Message string to extract subject is null");
        }
        String subj = "";
        int newlineNdx = msg.indexOf("\n");
        subj = newlineNdx >= 1 ? msg.substring(0, newlineNdx) : msg;
        StringBuffer subject = new StringBuffer("OpenAS2 Log (" + level.getName() + "): " + subj);
        return subject.toString();
    }

    protected String getSubject(Throwable t) {
        StringBuffer subject = new StringBuffer("OpenAS2 Exception: ");
        if (t instanceof WrappedException) {
            subject.append(((WrappedException)t).getSource().getClass().getName());
        } else {
            subject.append(t.getClass().getName());
        }
        subject.append(": ").append(t.getMessage());
        return subject.toString();
    }

    protected String getTemplateText() throws InvalidParameterException {
        try {
            File file = new File(this.getParameter(PARAM_BODYTEMPLATE, true));
            if (file.exists() && file.isFile()) {
                FileInputStream fIn = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                fIn.read(data);
                fIn.close();
                return new String(data);
            }
            return "";
        }
        catch (IOException ioe) {
            throw new InvalidParameterException("Error reading or parsing template file " + this.getParameter(PARAM_BODYTEMPLATE, true) + ":" + ioe.getMessage(), this, null, null);
        }
    }

    protected ParameterParser createParser() {
        CompositeParameters compParams = new CompositeParameters(false);
        return compParams;
    }

    protected CompositeParameters createParser(AS2Message msg, Throwable t, boolean terminated) {
        CompositeParameters params = new CompositeParameters(true);
        if (msg != null) {
            params.add("message", new MessageParameters(msg));
        } else {
            params.add("message", null);
        }
        if (msg != null && msg instanceof MessageMDN) {
            params.add("mdn", new MessageMDNParameters((MessageMDN)((Object)msg)));
        } else {
            params.add("mdn", null);
        }
        if (t != null) {
            params.add("exception", new ExceptionParameters(t, terminated));
        } else {
            params.add("exception", null);
        }
        return params;
    }

    protected String parseText(Throwable t, boolean terminated, String text) throws InvalidParameterException {
        AS2Message msg = null;
        if (t instanceof OpenAS2Exception) {
            msg = (AS2Message)((OpenAS2Exception)t).getSource("message");
        }
        CompositeParameters parser = this.createParser(msg, t, terminated);
        return ParameterParser.parse(text, parser);
    }

    protected String parseText(AS2Message msg, String text) throws InvalidParameterException {
        CompositeParameters parser = this.createParser(msg, null, false);
        return ParameterParser.parse(text, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(String subject, String text) throws OpenAS2Exception {
        block36: {
            String protocol = this.getParameter(PARAM_SMTPPROTOCOL, false);
            if (!(protocol != null && protocol.length() >= 1 || (protocol = (String)this.props.get("mail.transport.protocol")) != null && protocol.length() >= 1)) {
                protocol = "smtp";
            }
            String userName = null;
            String password = null;
            boolean isAuth = false;
            javax.mail.Session jmSession = null;
            try {
                isAuth = "true".equalsIgnoreCase(this.getParameter("smtpauth", "false"));
            }
            catch (InvalidParameterException invalidParameterException) {
                // empty catch block
            }
            if (isAuth) {
                this.props.put("mail." + protocol + ".auth", "true");
                try {
                    userName = this.getParameter("smtpuser", false);
                    if (userName == null) {
                        userName = (String)this.props.get("mail." + protocol + ".user");
                        if (userName == null) {
                            userName = (String)this.props.get("mail.user");
                        }
                        if (userName == null) {
                            this.getParameter("smtpuser", true);
                        }
                    }
                    password = this.getParameter("smtppwd", true);
                }
                catch (InvalidParameterException e) {
                    throw new OpenAS2Exception("Failed to find email logger parameter: " + Log.getExceptionMsg(e), e);
                }
            }
            final String uid = userName;
            final String pwd = password;
            if (isAuth) {
                this.props.put("mail." + protocol + ".user", uid);
                jmSession = javax.mail.Session.getDefaultInstance((Properties)this.props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(uid, pwd);
                    }
                });
            } else {
                jmSession = javax.mail.Session.getDefaultInstance((Properties)this.props);
            }
            if (this.isDebugOn) {
                jmSession.setDebug(true);
                jmSession.setDebugOut(System.out);
            }
            try {
                String serverPort;
                MimeMessage m = new MimeMessage(jmSession);
                String from = this.getParameter(PARAM_FROM, true);
                String fromDisplay = this.getParameter(PARAM_FROM_DISPLAY, false);
                if (fromDisplay == null || fromDisplay.length() < 1) {
                    fromDisplay = from;
                }
                try {
                    m.setFrom((Address)new InternetAddress(from, fromDisplay));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println("Check the text in the \"from_display\" parameter for encoding issues.");
                    e.printStackTrace();
                    m.setFrom((Address)new InternetAddress(from));
                }
                m.setSender((Address)new InternetAddress(this.getParameter(PARAM_FROM, true)));
                m.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.getParameter(PARAM_TO, true)));
                m.setSentDate(new Date());
                m.setSubject(subject);
                m.setText(text);
                String mailServer = this.getParameter(PARAM_SMTPSERVER, false);
                if (mailServer == null || mailServer.length() < 1) {
                    mailServer = (String)this.props.get("mail." + protocol + ".host");
                    if (mailServer == null || mailServer.length() < 1) {
                        mailServer = (String)this.props.get("mail.host");
                    }
                    if (mailServer == null || mailServer.length() < 1) {
                        this.getParameter(PARAM_SMTPSERVER, true);
                    }
                }
                if (mailServer != null) {
                    this.props.put("mail." + protocol + ".host", mailServer);
                }
                if ((serverPort = this.getParameter(PARAM_SMTPPORT, false)) == null || serverPort.length() < 1) {
                    serverPort = (String)this.props.get("mail." + protocol + ".port");
                    if (serverPort == null || serverPort.length() < 1) {
                        serverPort = (String)this.props.get("mail.port");
                    }
                    if (serverPort == null || serverPort.length() < 1) {
                        this.getParameter(PARAM_SMTPPORT, true);
                    }
                }
                if (serverPort != null) {
                    this.props.put("mail." + protocol + ".port", serverPort);
                }
                if (this.isDebugOn) {
                    System.out.println("Mail Logger Config:::");
                    System.out.println("\tSMTP server: " + this.props.get("mail.smtp.host"));
                    System.out.println("\tSMTP port: " + this.props.get("mail.smtp.port"));
                    System.out.println("\tSMTP protocol: " + protocol);
                    System.out.println("\tSMTP authentication: " + isAuth);
                    System.out.println("\tSMTP user name: " + uid);
                    System.out.println("\tSMTP password: " + pwd);
                }
                if (isAuth) {
                    try (Transport t = jmSession.getTransport(protocol);){
                        t.connect(uid, pwd);
                        t.sendMessage((Message)m, m.getAllRecipients());
                        break block36;
                    }
                }
                Transport.send((Message)m);
            }
            catch (MessagingException me) {
                me.printStackTrace();
            }
            catch (InvalidParameterException ipe) {
                ipe.printStackTrace();
            }
            finally {
                if (this.isDebugOn) {
                    System.out.println("Mail Logger EXIT...:::");
                }
            }
        }
    }
}

