/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.XMLSession;
import org.openas2.cmd.BaseCommandRegistry;
import org.openas2.cmd.Command;
import org.openas2.cmd.MultiCommand;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLCommandRegistry
extends BaseCommandRegistry {
    public static final String PARAM_FILENAME = "filename";

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.refresh();
    }

    public void load(InputStream in) throws ParserConfigurationException, SAXException, IOException, OpenAS2Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(in);
        Element root = document.getDocumentElement();
        NodeList rootNodes = root.getChildNodes();
        this.getCommands().clear();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node rootNode = rootNodes.item(i);
            String nodeName = rootNode.getNodeName();
            if (nodeName.equals("command")) {
                this.loadCommand(rootNode, null);
                continue;
            }
            if (!nodeName.equals("multicommand")) continue;
            this.loadMultiCommand(rootNode, null);
        }
    }

    public void refresh() throws OpenAS2Exception {
        try {
            this.load(new FileInputStream(this.getParameter(PARAM_FILENAME, true)));
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected void loadCommand(Node node, MultiCommand parent) throws OpenAS2Exception {
        Command cmd = (Command)XMLUtil.getComponent(node, (XMLSession)this.getSession());
        if (parent != null) {
            parent.getCommands().add(cmd);
        } else {
            this.getCommands().add(cmd);
        }
    }

    protected void loadMultiCommand(Node node, MultiCommand parent) throws OpenAS2Exception {
        MultiCommand cmd = new MultiCommand();
        cmd.init(this.getSession(), XMLUtil.mapAttributes(node));
        if (parent != null) {
            parent.getCommands().add(cmd);
        } else {
            this.getCommands().add(cmd);
        }
        NodeList childCmds = node.getChildNodes();
        for (int i = 0; i < childCmds.getLength(); ++i) {
            Node childNode = childCmds.item(i);
            String childName = childNode.getNodeName();
            if (childName.equals("command")) {
                this.loadCommand(childNode, cmd);
                continue;
            }
            if (!childName.equals("multicommand")) continue;
            this.loadMultiCommand(childNode, cmd);
        }
    }
}

