/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.sender;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.logging.Log;
import org.openas2.message.AS2Message;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.processor.sender.HttpResponseException;
import org.openas2.processor.sender.HttpSenderModule;
import org.openas2.util.AS2Util;
import org.openas2.util.DispositionType;
import org.openas2.util.HTTPUtil;
import org.openas2.util.ResponseWrapper;

public class MDNSenderModule
extends HttpSenderModule {
    public static String MDN_TYPE_OPT = "mdn-type-option";
    public static String MDN_TYPE_VAL_SYNC = "Synchronous";
    public static String MDN_TYPE_VAL_ASYNC = "Asynchronous";
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)MDNSenderModule.class.getSimpleName());

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        if (!action.equals("sendmdn")) {
            return false;
        }
        return msg instanceof AS2Message;
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"ASYNC MDN send started...");
        }
        if (options == null) {
            options = new HashMap<Object, Object>();
        }
        options.put("DIRECTION", "RECEIVE");
        BufferedOutputStream out = (BufferedOutputStream)options.get("buffered_output_stream");
        MessageMDN mdn = msg.getMDN();
        DispositionType disposition = new DispositionType(mdn.getAttribute("DISPOSITION"));
        if (msg.isRequestingAsynchMDN()) {
            try {
                if (!"resending_msg".equals(msg.getStatus())) {
                    HTTPUtil.sendHTTPResponse(out, 200, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Calling asynch MDN sender....");
            }
            if (!this.sendAsyncMDN(mdn, ((AS2Message)msg).getAsyncMDNurl(), disposition, options)) {
                return;
            }
        } else {
            Enumeration headers;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            MimeBodyPart part = mdn.getData();
            try {
                IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)data);
            }
            catch (Exception e) {
                WrappedException we = new WrappedException("Error writing MDN to byte array.", e);
                we.addSource("message", msg);
                throw new WrappedException(we);
            }
            mdn.setHeader("Content-Length", Integer.toString(data.size()));
            try {
                HTTPUtil.sendHTTPResponse(out, 200, data, mdn.getHeaders().getAllHeaderLines());
            }
            catch (IOException e) {
                WrappedException we = new WrappedException("Error writing MDN to output stream.", e);
                we.addSource("message", msg);
                throw new WrappedException(we);
            }
            if (this.logger.isTraceEnabled() && (headers = mdn.getHeaders().getAllHeaders()).hasMoreElements()) {
                this.logger.trace((Object)("MDN HEADERS SENT: " + HTTPUtil.printHeaders(headers, ";", "=") + msg.getLogMsgID()));
            }
        }
        this.getSession().getProcessor().handle("storemdn", msg, null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("sent MDN [" + disposition.toString() + "]" + msg.getLogMsgID()));
        }
    }

    private boolean sendAsyncMDN(MessageMDN mdn, String url, DispositionType disposition, Map<Object, Object> options) throws OpenAS2Exception {
        Message msg = mdn.getMessage();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ASYNC MDN attempting connection to: " + url + mdn.getMessage().getLogMsgID()));
            }
            long maxSize = msg.getPartnership().getNoChunkedMaxSize();
            ResponseWrapper resp = HTTPUtil.execRequest("POST", url, mdn.getHeaders().getAllHeaders(), null, mdn.getData().getInputStream(), this.getHttpOptions(), maxSize);
            int respCode = resp.getStatusCode();
            if (respCode != 200 && respCode != 201 && respCode != 202 && respCode != 206 && respCode != 204) {
                if (this.logger.isErrorEnabled()) {
                    msg.setLogMsg("Error sending AsyncMDN [" + disposition.toString() + "] HTTP response code: " + respCode);
                    this.logger.error((Object)msg);
                }
                throw new HttpResponseException(url.toString(), respCode, resp.getStatusPhrase());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("sent AsyncMDN [" + disposition.toString() + "] OK " + msg.getLogMsgID()));
            }
            this.getSession().getProcessor().handle("storemdn", msg, null);
            msg.setOption("STATE", "msg_rxd_mdn_sent_ok");
            msg.trackMsgState(this.getSession());
        }
        catch (HttpResponseException hre) {
            this.logger.warn((Object)("HTTP exception sending ASYNC MDN: " + Log.getExceptionMsg(hre) + msg.getLogMsgID()), (Throwable)hre);
            hre.terminate();
            this.resend(msg, hre);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
            return false;
        }
        catch (IOException ioe) {
            this.logger.warn((Object)("IO exception sending ASYNC MDN: " + Log.getExceptionMsg(ioe) + msg.getLogMsgID()), (Throwable)ioe);
            WrappedException wioe = new WrappedException(ioe);
            wioe.addSource("message", msg);
            wioe.terminate();
            this.resend(msg, wioe);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
            return false;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Unexpected exception sending ASYNC MDN: " + Log.getExceptionMsg(e) + msg.getLogMsgID()), (Throwable)e);
            this.getSession().getProcessor().handle("storemdn", msg, null);
            msg.setOption("STATE", "mdn_sending_exception");
            msg.trackMsgState(this.getSession());
            throw new WrappedException(e);
        }
        return true;
    }

    protected void resend(Message msg, OpenAS2Exception cause) throws OpenAS2Exception {
        Map<Object, Object> msgOptions = msg.getOptions();
        String tries = AS2Util.retries(msgOptions, this.getParameter("retries", false));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MDN resend retries: MSG - " + msgOptions.get("retries") + "   ::: RETRIES - " + tries));
        }
        int retries = -1;
        if (tries == null) {
            tries = "-1";
        }
        try {
            retries = Integer.parseInt(tries);
        }
        catch (Exception e) {
            msg.setLogMsg("The retry count is not a valid integer value: " + tries);
            this.logger.error((Object)msg);
        }
        if (msgOptions.get("retries") == null) {
            msgOptions.put("retries", retries);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Send MDN retry count: " + retries));
        }
        if (retries >= 0 && retries-- <= 0) {
            msg.setLogMsg("MDN response abandoned after retry limit reached.");
            this.logger.error((Object)msg);
            msg.setOption("STATE", "msg_rxd_mdn_sending_fail");
            msg.trackMsgState(this.getSession());
            AS2Util.cleanupFiles(msg, false);
            throw new OpenAS2Exception("MDN response abandoned after retry limit reached." + msg.getLogMsgID());
        }
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("cause", cause);
        options.put("initial_sender", this);
        options.put("resend_method", "sendmdn");
        options.put("retries", "" + retries);
        this.getSession().getProcessor().handle("resend", msg, options);
    }
}

