/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.partner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.BasePartnershipFactory;
import org.openas2.partner.Partnership;
import org.openas2.schedule.HasSchedule;
import org.openas2.support.FileMonitorAdapter;
import org.openas2.util.AS2Util;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPartnershipFactory
extends BasePartnershipFactory
implements HasSchedule {
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_INTERVAL = "interval";
    private Map<String, Object> partners;
    private Log logger = LogFactory.getLog((String)XMLPartnershipFactory.class.getSimpleName());

    private int getRefreshInterval() throws InvalidParameterException {
        return this.getParameterInt(PARAM_INTERVAL, false);
    }

    String getFilename() throws InvalidParameterException {
        return this.getParameter(PARAM_FILENAME, true);
    }

    @Override
    public Map<String, Object> getPartners() {
        if (this.partners == null) {
            this.partners = new HashMap<String, Object>();
        }
        return this.partners;
    }

    private void setPartners(Map<String, Object> map) {
        this.partners = map;
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() throws OpenAS2Exception {
        try (FileInputStream inputStream = new FileInputStream(this.getFilename());){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList rootNodes = root.getChildNodes();
            HashMap<String, Object> newPartners = new HashMap<String, Object>();
            ArrayList<Partnership> newPartnerships = new ArrayList<Partnership>();
            for (int i = 0; i < rootNodes.getLength(); ++i) {
                Node rootNode = rootNodes.item(i);
                String nodeName = rootNode.getNodeName();
                if (nodeName.equals("partner")) {
                    this.loadPartner(newPartners, rootNode);
                    continue;
                }
                if (!nodeName.equals("partnership")) continue;
                this.loadPartnership(newPartners, newPartnerships, rootNode);
            }
            XMLPartnershipFactory xMLPartnershipFactory = this;
            synchronized (xMLPartnershipFactory) {
                this.setPartners(newPartners);
                this.setPartnerships(newPartnerships);
            }
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    private void loadAttributes(Node node, Partnership partnership) throws OpenAS2Exception {
        Map<String, String> nodes = XMLUtil.mapAttributeNodes(node.getChildNodes(), "attribute", "name", "value");
        AS2Util.attributeEnhancer(nodes);
        partnership.getAttributes().putAll(nodes);
    }

    public void loadPartner(Map<String, Object> partners, Node node) throws OpenAS2Exception {
        String[] requiredAttributes = new String[]{"name"};
        Map<String, String> newPartner = XMLUtil.mapAttributes(node, requiredAttributes);
        String name = newPartner.get("name");
        if (partners.get(name) != null) {
            throw new OpenAS2Exception("Partner is defined more than once: " + name);
        }
        partners.put(name, newPartner);
    }

    private void loadPartnerIDs(Map<String, Object> partners, String partnershipName, Node partnershipNode, String partnerType, Map<String, Object> idMap) throws OpenAS2Exception {
        Node partnerNode = XMLUtil.findChildNode(partnershipNode, partnerType);
        if (partnerNode == null) {
            throw new OpenAS2Exception("Partnership \"" + partnershipName + "\" is missing sender");
        }
        Map<String, String> partnerAttr = XMLUtil.mapAttributes(partnerNode);
        String partnerName = partnerAttr.get("name");
        if (partnerName != null) {
            Map map = (Map)partners.get(partnerName);
            Map partner = map;
            if (partner == null) {
                throw new OpenAS2Exception("Partnership " + partnershipName + " has an undefined " + partnerType + ": " + partnerName);
            }
            idMap.putAll(partner);
        }
        idMap.putAll(partnerAttr);
    }

    public void loadPartnership(Map<String, Object> partners, List<Partnership> partnerships, Node node) throws OpenAS2Exception {
        Partnership partnership = new Partnership();
        String[] requiredAttributes = new String[]{"name"};
        Map<String, String> psAttributes = XMLUtil.mapAttributes(node, requiredAttributes);
        String name = psAttributes.get("name");
        if (this.getPartnership(partnerships, name) != null) {
            throw new OpenAS2Exception("Partnership is defined more than once: " + name);
        }
        partnership.setName(name);
        this.loadPartnerIDs(partners, name, node, "sender", partnership.getSenderIDs());
        this.loadPartnerIDs(partners, name, node, "receiver", partnership.getReceiverIDs());
        this.loadAttributes(node, partnership);
        partnerships.add(partnership);
    }

    public void storePartnership() throws OpenAS2Exception {
        String fn = this.getFilename();
        DecimalFormat df = new DecimalFormat("0000000");
        long l = 0L;
        File f = null;
        while ((f = new File(fn + '.' + df.format(l))).exists()) {
            ++l;
        }
        this.logger.info((Object)("backing up " + fn + " to " + f.getName()));
        File fr = new File(fn);
        fr.renameTo(f);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(fn));
            Map<String, Object> partner = this.partners;
            pw.println("<partnerships>");
            for (Map.Entry<String, Object> ptrnData : partner.entrySet()) {
                HashMap partnerMap = (HashMap)ptrnData.getValue();
                pw.print("  <partner ");
                Iterator attrIt = partnerMap.entrySet().iterator();
                while (attrIt.hasNext()) {
                    Map.Entry attribute = attrIt.next();
                    pw.print((String)attribute.getKey() + "=\"" + attribute.getValue() + "\"");
                    if (!attrIt.hasNext()) continue;
                    pw.print("\n           ");
                }
                pw.println("/>");
            }
            List<Partnership> partnerShips = this.getPartnerships();
            ListIterator<Partnership> partnerLIt = partnerShips.listIterator();
            while (partnerLIt.hasNext()) {
                Partnership partnership = partnerLIt.next();
                pw.println("  <partnership name=\"" + partnership.getName() + "\">");
                pw.println("    <sender name=\"" + partnership.getSenderIDs().get("name") + "\"/>");
                pw.println("    <receiver name=\"" + partnership.getReceiverIDs().get("name") + "\"/>");
                Map<String, String> partnershipMap = partnership.getAttributes();
                for (Map.Entry<String, String> partnershipData : partnershipMap.entrySet()) {
                    pw.println("    <attribute name=\"" + partnershipData.getKey() + "\" value=\"" + partnershipData.getValue() + "\"/>");
                }
                pw.println("  </partnership>");
            }
            pw.println("</partnerships>");
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            throw new WrappedException(e);
        }
    }

    @Override
    public void schedule(ScheduledExecutorService executor) throws OpenAS2Exception {
        new FileMonitorAdapter(){

            @Override
            public void onConfigFileChanged() throws OpenAS2Exception {
                XMLPartnershipFactory.this.refresh();
                XMLPartnershipFactory.this.logger.debug((Object)"- Partnerships Reloaded -");
            }
        }.scheduleIfNeed(executor, new File(this.getFilename()), this.getRefreshInterval(), TimeUnit.SECONDS);
    }
}

