/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.IOException;
import javax.mail.internet.InternetHeaders;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.openas2.OpenAS2Exception;

public class ResponseWrapper {
    private String _transferTimeMs = "-1";
    private int _statusCode = 0;
    private String _statusPhrase = null;
    private InternetHeaders _headers = new InternetHeaders();
    private byte[] _body = null;

    public ResponseWrapper(HttpResponse response) throws OpenAS2Exception {
        this.setStatusCode(response.getStatusLine().getStatusCode());
        this.setStatusPhrase(response.getStatusLine().getReasonPhrase());
        for (Header header : response.getAllHeaders()) {
            this.addHeaderLine(header.toString());
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        byte[] data = null;
        try {
            data = EntityUtils.toByteArray((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new OpenAS2Exception("Failed to read response content", e);
        }
        this.setBody(data);
    }

    public InternetHeaders getHeaders() {
        return this._headers;
    }

    public void setHeaders(InternetHeaders headers) {
        this._headers = headers;
    }

    public void addHeaderLine(String headerLine) {
        this.getHeaders().addHeaderLine(headerLine);
    }

    public String getTransferTimeMs() {
        return this._transferTimeMs;
    }

    public void setTransferTimeMs(String transferTimeMs) {
        this._transferTimeMs = transferTimeMs;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    protected void setStatusCode(int n) {
        this._statusCode = n;
    }

    public String getStatusPhrase() {
        return this._statusPhrase;
    }

    public void setStatusPhrase(String statusPhrase) {
        this._statusPhrase = statusPhrase;
    }

    public byte[] getBody() {
        return this._body;
    }

    protected void setBody(byte[] body) {
        this._body = body;
    }
}

