/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.message.Message;
import org.openas2.params.InvalidParameterException;
import org.openas2.processor.BaseProcessorModule;
import org.openas2.processor.storage.StorageModule;
import org.openas2.util.IOUtil;

public abstract class BaseStorageModule
extends BaseProcessorModule
implements StorageModule {
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_PROTOCOL = "protocol";
    public static final String PARAM_TEMPDIR = "tempdir";

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        try {
            if (!action.equals(this.getModuleAction())) {
                return false;
            }
            String modProtocol = this.getParameter(PARAM_PROTOCOL, false);
            String msgProtocol = msg.getProtocol();
            if (modProtocol != null) {
                return msgProtocol != null && msgProtocol.equals(modProtocol);
            }
            return true;
        }
        catch (OpenAS2Exception oae) {
            return false;
        }
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        this.getParameter(PARAM_FILENAME, true);
    }

    protected abstract String getModuleAction();

    protected File getFile(Message msg, String fileParam) throws IOException, OpenAS2Exception {
        return this.getFile(msg, fileParam, "");
    }

    protected File getFile(Message msg, String fileParam, String action) throws IOException, OpenAS2Exception {
        String filename = this.getFilename(msg, fileParam, action);
        filename = IOUtil.cleanFilename(filename);
        File file = new File(filename);
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        return file;
    }

    protected abstract String getFilename(Message var1, String var2, String var3) throws InvalidParameterException;

    protected void store(File msgFile, InputStream in) throws IOException, OpenAS2Exception {
        String tempDirname = this.getParameter(PARAM_TEMPDIR, false);
        if (tempDirname != null) {
            File tempDir = IOUtil.getDirectoryFile(tempDirname);
            String tempFilename = msgFile.getName();
            File tempFile = IOUtil.getUnique(tempDir, tempFilename);
            this.writeStream(in, tempFile);
            IOUtil.moveFile(tempFile, msgFile, true);
        } else {
            this.writeStream(in, msgFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStream(InputStream in, File destination) throws IOException {
        try (FileOutputStream out = new FileOutputStream(destination);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
    }
}

