/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.msgtracking;

import java.util.HashMap;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.processor.BaseProcessorModule;
import org.openas2.processor.msgtracking.TrackingModule;

public abstract class BaseMsgTrackingModule
extends BaseProcessorModule
implements TrackingModule {
    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        Map<String, String> fields = this.buildMap(msg, options);
        this.persist(msg, fields);
    }

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        return action.equals(this.getModuleAction());
    }

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
    }

    protected abstract String getModuleAction();

    protected abstract void persist(Message var1, Map<String, String> var2);

    protected Map<String, String> buildMap(Message msg, Map<Object, Object> options) {
        String sender;
        HashMap<String, String> map = new HashMap<String, String>();
        String msgId = msg.getMessageID();
        MessageMDN mdn = msg.getMDN();
        if (mdn != null) {
            map.put("MDN_ID", mdn.getMessageID());
            map.put("MDN_RESPONSE", msg.getMDN().getText());
            String originalMsgId = mdn.getAttribute("ORIGINAL_MESSAGE_ID");
            if (originalMsgId != null && !msgId.equals(originalMsgId)) {
                msgId = originalMsgId;
            }
        }
        map.put("MSG_ID", msgId);
        map.put("PRIOR_MSG_ID", msg.getAttribute("PRIOR_MSG_ID"));
        String direction = (String)options.get("DIRECTION");
        map.put("DIRECTION", direction == null ? "SEND" : direction);
        String isResend = (String)options.get("IS_RESEND");
        if (isResend != null) {
            map.put("IS_RESEND", isResend);
            map.put("RESEND_COUNT", (String)options.get("retries"));
        }
        if ((sender = msg.getPartnership().getSenderID("as2_id")) == null) {
            sender = mdn.getPartnership().getSenderID("as2_id");
        }
        map.put("SENDER_ID", sender);
        String receiver = msg.getPartnership().getReceiverID("as2_id");
        if (receiver == null) {
            receiver = mdn.getPartnership().getReceiverID("as2_id");
        }
        map.put("RECEIVER_ID", receiver);
        map.put("STATUS", msg.getStatus());
        String state = (String)options.get("STATE");
        map.put("STATE", state);
        map.put("STATE_MSG", Message.STATE_MSGS.get(state));
        map.put("SIGNATURE_ALGORITHM", msg.getPartnership().getAttribute("sign"));
        map.put("ENCRYPTION_ALGORITHM", msg.getPartnership().getAttribute("encrypt"));
        map.put("COMPRESSION", msg.getPartnership().getAttribute("compression"));
        map.put("FILE_NAME", msg.getPayloadFilename());
        map.put("CONTENT_TYPE", msg.getContentType());
        map.put("CONTENT_TRANSFER_ENCODING", msg.getHeader("Content-Transfer-Encoding"));
        map.put("MDN_MODE", msg.getPartnership().isAsyncMDN() ? "ASYNC" : "SYNC");
        return map;
    }

    public static class FIELDS {
        public static final String MSG_ID = "MSG_ID";
        public static final String PRIOR_MSG_ID = "PRIOR_MSG_ID";
        public static final String MDN_ID = "MDN_ID";
        public static final String DIRECTION = "DIRECTION";
        public static final String IS_RESEND = "IS_RESEND";
        public static final String RESEND_COUNT = "RESEND_COUNT";
        public static final String SENDER_ID = "SENDER_ID";
        public static final String RECEIVER_ID = "RECEIVER_ID";
        public static final String STATUS = "STATUS";
        public static final String STATE = "STATE";
        public static final String SIGNATURE_ALGORITHM = "SIGNATURE_ALGORITHM";
        public static final String ENCRYPTION_ALGORITHM = "ENCRYPTION_ALGORITHM";
        public static final String COMPRESSION = "COMPRESSION";
        public static final String FILE_NAME = "FILE_NAME";
        public static final String CONTENT_TYPE = "CONTENT_TYPE";
        public static final String CONTENT_TRANSFER_ENCODING = "CONTENT_TRANSFER_ENCODING";
        public static final String MDN_MODE = "MDN_MODE";
        public static final String MDN_RESPONSE = "MDN_RESPONSE";
        public static final String STATE_MSG = "STATE_MSG";
        public static final String CREATE_DT = "CREATE_DT";
        public static final String UPDATE_DT = "UPDATE_DT";
    }
}

