/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.partner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openas2.util.Properties;

public class Partnership
implements Serializable {
    public static final String PTYPE_SENDER = "sender";
    public static final String PTYPE_RECEIVER = "receiver";
    public static final String PID_AS2 = "as2_id";
    public static final String PID_X509_ALIAS = "x509_alias";
    public static final String PID_EMAIL = "email";
    public static final String PA_SUBJECT = "subject";
    public static final String PA_CONTENT_TRANSFER_ENCODING = "content_transfer_encoding";
    public static final String PA_REMOVE_PROTECTION_ATTRIB = "remove_cms_algorithm_protection_attrib";
    public static final String PA_SET_CONTENT_TRANSFER_ENCODING_OMBP = "set_content_transfer_encoding_on_outer_mime_bodypart";
    public static final String PA_RESEND_REQUIRES_NEW_MESSAGE_ID = "resend_requires_new_message_id";
    public static final String PA_COMPRESSION_TYPE = "compression";
    public static final String PA_SIGNATURE_ALGORITHM = "sign";
    public static final String PA_ENCRYPTION_ALGORITHM = "encrypt";
    public static final String PA_AS2_URL = "as2_url";
    public static final String PA_AS2_MDN_TO = "as2_mdn_to";
    public static final String PA_AS2_MDN_OPTIONS = "as2_mdn_options";
    public static final String PA_AS2_RECEIPT_OPTION = "as2_receipt_option";
    public static final String PA_RESEND_MAX_RETRIES = "resend_max_retries";
    public static final String PA_CUSTOM_MIME_HEADERS = "custom_mime_headers";
    public static final String PA_ADD_CUSTOM_MIME_HEADERS_TO_HTTP = "add_custom_mime_headers_to_http";
    public static final String PA_CUSTOM_MIME_HEADER_NAMES_FROM_FILENAME = "custom_mime_header_names_from_filename";
    public static final String PA_CUSTOM_MIME_HEADER_NAME_DELIMITERS_IN_FILENAME = "custom_mime_header_name_delimiters_in_filename";
    public static final String PA_CUSTOM_MIME_HEADER_NAMES_REGEX_ON_FILENAME = "custom_mime_header_names_regex_on_filename";
    public static final String PAIB_NAMES_FROM_FILENAME = "attribute_names_from_filename";
    public static final String PAIB_VALUES_REGEX_ON_FILENAME = "attribute_values_regex_on_filename";
    public static final String PA_HTTP_NO_CHUNKED_MAX_SIZE = "no_chunked_max_size";
    public static final String PA_BLOCK_ERROR_MDN = "blockerrormdn";
    private static final long serialVersionUID = -8365608387462470629L;
    private Map<String, String> attributes;
    private Map<String, Object> receiverIDs;
    private Map<String, Object> senderIDs;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAttribute(String id, String value) {
        this.getAttributes().put(id, value);
    }

    public String getAttribute(String id) {
        return this.getAttributes().get(id);
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getAttributeOrProperty(String id, String defaultValue) {
        String val = this.getAttributes().get(id);
        if (val == null || val.length() < 1) {
            val = Properties.getProperty(id, defaultValue);
        }
        return val;
    }

    public void setReceiverID(String id, String value) {
        this.getReceiverIDs().put(id, value);
    }

    public String getReceiverID(String id) {
        return (String)this.getReceiverIDs().get(id);
    }

    public Map<String, Object> getReceiverIDs() {
        if (this.receiverIDs == null) {
            this.receiverIDs = new HashMap<String, Object>();
        }
        return this.receiverIDs;
    }

    public void setReceiverIDs(Map<String, Object> receiverIDs) {
        this.receiverIDs = receiverIDs;
    }

    public void setSenderID(String id, String value) {
        this.getSenderIDs().put(id, value);
    }

    public String getSenderID(String id) {
        return (String)this.getSenderIDs().get(id);
    }

    public Map<String, Object> getSenderIDs() {
        if (this.senderIDs == null) {
            this.senderIDs = new HashMap<String, Object>();
        }
        return this.senderIDs;
    }

    public void setSenderIDs(Map<String, Object> senderIDs) {
        this.senderIDs = senderIDs;
    }

    public boolean matches(Partnership partnership) {
        Map<String, Object> senderIDs = partnership.getSenderIDs();
        Map<String, Object> receiverIDs = partnership.getReceiverIDs();
        if (this.compareIDs(senderIDs, this.getSenderIDs())) {
            return true;
        }
        return this.compareIDs(receiverIDs, this.getReceiverIDs());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Partnership " + this.getName());
        buf.append(" Sender IDs = ").append(this.getSenderIDs());
        buf.append(" Receiver IDs = ").append(this.getReceiverIDs());
        buf.append(" Attributes = ").append(this.getAttributes());
        return buf.toString();
    }

    protected boolean compareIDs(Map<String, Object> ids, Map<String, Object> compareTo) {
        Set<Map.Entry<String, Object>> idSet = ids.entrySet();
        Iterator<Map.Entry<String, Object>> it = idSet.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            Map.Entry<String, Object> currentId = it.next();
            Object currentValue = currentId.getValue();
            Object compareValue = compareTo.get(currentId.getKey());
            if (currentValue != null && compareValue == null) {
                return false;
            }
            if (currentValue == null && compareValue != null) {
                return false;
            }
            if (currentValue.equals(compareValue)) continue;
            return false;
        }
        return true;
    }

    public void copy(Partnership partnership) {
        if (partnership.getName() != null) {
            this.setName(partnership.getName());
        }
        this.getSenderIDs().putAll(partnership.getSenderIDs());
        this.getReceiverIDs().putAll(partnership.getReceiverIDs());
        this.getAttributes().putAll(partnership.getAttributes());
    }

    public boolean isAsyncMDN() {
        String receiptOptions = this.getAttribute(PA_AS2_RECEIPT_OPTION);
        return receiptOptions != null && receiptOptions.length() > 0;
    }

    public boolean isSetTransferEncodingOnInitialBodyPart() {
        String setTxfrEncoding = this.getAttribute("set_transfer_encoding_on_inital_body_part");
        return setTxfrEncoding == null || "true".equals(setTxfrEncoding);
    }

    public boolean isPreventCanonicalization() {
        String preventCanonicalization = this.getAttribute("prevent_canonicalization_for_mic");
        return preventCanonicalization != null && "true".equals(preventCanonicalization);
    }

    public boolean isRenameDigestToOldName() {
        String removeDash = this.getAttribute("rename_digest_to_old_name");
        return removeDash != null && "true".equals(removeDash);
    }

    public boolean isRemoveCmsAlgorithmProtectionAttr() {
        return "true".equalsIgnoreCase(this.getAttribute(PA_REMOVE_PROTECTION_ATTRIB));
    }

    public boolean isNoChunkedTransfer() {
        return this.getNoChunkedMaxSize() > 0L;
    }

    public long getNoChunkedMaxSize() {
        long max = 0L;
        try {
            max = Long.valueOf(this.getAttribute(PA_HTTP_NO_CHUNKED_MAX_SIZE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return max;
    }
}

