/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.openas2.OpenAS2Exception;
import org.openas2.message.InvalidMessageException;
import org.openas2.util.ProfilerStub;

public class IOUtilOld {
    private static final String VALID_FILENAME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@-";

    public static File getDirectoryFile(String directory) throws IOException {
        File directoryFile = new File(directory);
        if (!directoryFile.exists() && !directoryFile.mkdirs()) {
            throw new IOException("Could not create directory: " + directory);
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException("Invalid directory: " + directory);
        }
        return directoryFile;
    }

    public static String getTransferRate(int bytes, ProfilerStub stub) {
        StringBuffer buf = new StringBuffer();
        buf.append(bytes).append(" bytes in ");
        buf.append(stub.getCombined()).append(" at ");
        long time = stub.getDifference();
        if (time != 0L) {
            double stime = (double)time / 1000.0;
            long rate = Math.round((double)bytes / stime);
            buf.append(IOUtilOld.getTransferRate(rate));
        } else {
            buf.append(IOUtilOld.getTransferRate(bytes));
        }
        return buf.toString();
    }

    private static String getTransferRate(long bytesPerSecond) {
        StringBuffer buf = new StringBuffer();
        long kbytesPerSecond = bytesPerSecond / 1024L;
        if (bytesPerSecond < 1024L) {
            buf.append(bytesPerSecond).append(" Bps");
        } else if (kbytesPerSecond < 1024L) {
            buf.append(kbytesPerSecond).append(".").append(bytesPerSecond % 1024L).append(" KBps");
        } else {
            buf.append(kbytesPerSecond / 1024L).append(".").append(kbytesPerSecond % 1024L).append(" MBps");
        }
        return buf.toString();
    }

    public static File getUnique(File dir, String filename) {
        filename = IOUtilOld.cleanFilename(filename);
        return new File(dir, filename + "." + UUID.randomUUID());
    }

    public static String cleanFilename(String filename) {
        byte[] fnBytes = filename.getBytes();
        for (int i = 0; i < fnBytes.length; ++i) {
            byte c = fnBytes[i];
            if (VALID_FILENAME_CHARS.indexOf(c) != -1) continue;
            fnBytes[i] = 95;
        }
        return new String(fnBytes);
    }

    public static void handleError(File file, String errorDirectory) throws OpenAS2Exception {
        File destFile = null;
        try {
            File errorDir = IOUtilOld.getDirectoryFile(errorDirectory);
            destFile = new File(errorDir, file.getName());
            destFile = IOUtilOld.moveFile(file, destFile, false, true);
        }
        catch (IOException ioe) {
            InvalidMessageException im = new InvalidMessageException("Failed to move " + file.getAbsolutePath() + " to error directory " + destFile.getAbsolutePath());
            im.initCause(ioe);
            throw im;
        }
        InvalidMessageException imMoved = new InvalidMessageException("Moved " + file.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        imMoved.terminate();
    }

    public static File moveFile(File src, File dest, boolean overwrite, boolean rename) throws IOException {
        if (!overwrite && dest.exists()) {
            if (rename) {
                dest = IOUtilOld.getUnique(dest.getAbsoluteFile().getParentFile(), dest.getName());
            } else {
                throw new IOException("File already exists: " + dest);
            }
        }
        FileUtils.copyFile((File)src, (File)dest);
        if (!src.delete()) {
            dest.delete();
            throw new IOException("Move failed, unable to delete " + src);
        }
        return dest;
    }

    public static void deleteFile(File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        boolean canUseNio = true;
        try {
            Class.forName("java.nio.file.Path");
        }
        catch (ClassNotFoundException e) {
            canUseNio = false;
        }
        if (canUseNio) {
            Path fp = f.toPath();
            Files.delete(fp);
        } else if (!f.delete()) {
            throw new IOException("Failed to delete file: " + f.getName());
        }
    }

    public static File[] getFiles(File dir, final String extensionFilter) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("." + extensionFilter);
            }
        });
    }
}

