/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;
import org.openas2.util.Properties;

public class DateUtil {
    public static String formatDate(String format, Date value) {
        return FastDateFormat.getInstance((String)format).format(value);
    }

    public static String formatDate(String format, Date value, Locale locale) {
        return FastDateFormat.getInstance((String)format, (Locale)locale).format(value);
    }

    public static String formatDate(String format) {
        return DateUtil.formatDate(format, new Date());
    }

    public static String formatDate(String format, Locale locale) {
        return DateUtil.formatDate(format, new Date(), locale);
    }

    public static Date parseDate(String format, String value) throws ParseException {
        return FastDateFormat.getInstance((String)format).parse(value);
    }

    public static String getSqlTimestamp() {
        return DateUtil.getSqlTimestamp(new Date());
    }

    private static String getSqlTimestamp(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.formatDate(Properties.getProperty("sql_timestamp_format", "yyyy-MM-dd HH:mm:ss.SSS"), date);
    }
}

