/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.schedule;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.BaseComponent;
import org.openas2.Component;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.params.InvalidParameterException;
import org.openas2.schedule.HasSchedule;

public class SchedulerComponent
extends BaseComponent {
    public static final String PARAMETER_THREADS = "threads";
    private static final int MIN_AMOUNT_OF_THREADS = 6;
    private Log logger = LogFactory.getLog((String)SchedulerComponent.class.getSimpleName());
    private ScheduledExecutorService executorService;

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.createExecutor();
        this.scheduleComponentsTasks(session);
    }

    private void createExecutor() throws InvalidParameterException {
        int configuredAmountOfThreads = this.getParameterInt(PARAMETER_THREADS, false);
        int amountOfThreads = configuredAmountOfThreads < 6 ? 6 : configuredAmountOfThreads;
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(this.getName() + "-Thread-%d").build();
        this.executorService = Executors.newScheduledThreadPool(amountOfThreads, (ThreadFactory)threadFactory);
        this.logger.debug((Object)"Scheduler module is ready.");
    }

    private void scheduleComponentsTasks(Session session) throws OpenAS2Exception {
        for (Component component : session.getComponents().values()) {
            if (!HasSchedule.class.isAssignableFrom(component.getClass())) continue;
            ((HasSchedule)HasSchedule.class.cast(component)).schedule(this.executorService);
        }
    }

    @Override
    public void destroy() throws Exception {
        this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        this.executorService.shutdownNow();
    }
}

