/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.params;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.openas2.OpenAS2Exception;
import org.openas2.params.InvalidParameterException;

public abstract class ParameterParser {
    public abstract void setParameter(String var1, String var2) throws InvalidParameterException;

    public abstract String getParameter(String var1) throws InvalidParameterException;

    public void setParameters(String encodedParams) throws InvalidParameterException {
        StringTokenizer params = new StringTokenizer(encodedParams, "=,", false);
        while (params.hasMoreTokens()) {
            String key = params.nextToken().trim();
            if (!params.hasMoreTokens()) {
                throw new InvalidParameterException("Invalid value for encoded param \"" + encodedParams + "\"", this, key, null);
            }
            String value = params.nextToken();
            this.setParameter(key, value);
        }
    }

    public void setParameters(String format, String delimiters, String value) throws OpenAS2Exception {
        List<String> keys = this.parseKeys(format);
        StringTokenizer valueTokens = new StringTokenizer(value, delimiters, false);
        Iterator<String> keyIt = keys.iterator();
        while (keyIt.hasNext()) {
            if (!valueTokens.hasMoreTokens()) {
                throw new OpenAS2Exception("String value does not match format: Format=" + format + " ::: Value=" + value + " ::: String delimiters=" + delimiters);
            }
            String key = keyIt.next().trim();
            if (key.equals("")) continue;
            this.setParameter(key, valueTokens.nextToken());
        }
    }

    public static String parse(String format, ParameterParser parser) throws InvalidParameterException {
        return parser.format(format);
    }

    public String format(String format) throws InvalidParameterException {
        StringBuffer result = new StringBuffer();
        for (int next = 0; next < format.length(); ++next) {
            int prev = next;
            if ((next = format.indexOf(36, prev)) == -1) {
                result.append(format.substring(prev, format.length()));
                break;
            }
            if (next > prev) {
                result.append(format.substring(prev, next));
            }
            if ((next = format.indexOf(36, prev = next + 1)) == -1) {
                throw new InvalidParameterException("Invalid key (missing closing $)");
            }
            if (next == prev) {
                result.append("$");
                continue;
            }
            result.append(this.getParameter(format.substring(prev, next)));
        }
        return result.toString();
    }

    protected List<String> parseKeys(String format) {
        StringTokenizer tokens = new StringTokenizer(format, ",", false);
        ArrayList<String> keys = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            keys.add(tokens.nextToken());
        }
        return keys;
    }
}

