/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.logging.BaseLogger;
import org.openas2.logging.Level;
import org.openas2.message.Message;

public class SocketLogger
extends BaseLogger {
    public static final String PARAM_PORTID = "portid";
    public static final String PARAM_IPADDDR = "ipaddr";
    public static final int iQUEUESIZE = 100;
    private int port = 0;
    private String ipAddr = null;

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        String portID = this.getParameter(PARAM_PORTID, true);
        this.ipAddr = this.getParameter(PARAM_IPADDDR, true);
        try {
            this.port = Integer.parseInt(portID);
        }
        catch (NumberFormatException nfe) {
            throw new OpenAS2Exception("portid is not a valid integer value, see \"" + portID + "\"", nfe);
        }
    }

    @Override
    public void doLog(Level level, String msgText, Message as2Msg) {
        this.sendToSocket(this.getFormatter().format(level, msgText + (as2Msg == null ? "" : as2Msg.getLogMsgID())));
    }

    public void sendToSocket(String msgText) {
        try {
            Socket sckt = new Socket(this.ipAddr, this.port);
            OutputStream os = sckt.getOutputStream();
            os.write(msgText.getBytes());
            os.flush();
            os.close();
            sckt.close();
        }
        catch (UnknownHostException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getShowDefaults() {
        return "all";
    }

    @Override
    protected void doLog(Throwable t, boolean terminated) {
        this.sendToSocket(this.getFormatter().format(t, terminated));
    }
}

