/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openas2.lib.OpenAS2Exception;

public class DispositionOptions {
    private String micAlgorithm;
    private String micAlgorithmImportance;
    private String protocol;
    private String protocolImportance;

    public DispositionOptions(String options) throws OpenAS2Exception {
        this.parseOptions(options);
    }

    public void setMicAlgorithm(String micalg) {
        this.micAlgorithm = micalg;
    }

    public String getMicAlgorithm() {
        return this.micAlgorithm;
    }

    public void setMicAlgorithmImportance(String micalgImportance) {
        this.micAlgorithmImportance = micalgImportance;
    }

    public String getMicAlgorithmImportance() {
        return this.micAlgorithmImportance;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocolImportance(String protocolImportance) {
        this.protocolImportance = protocolImportance;
    }

    public String getProtocolImportance() {
        return this.protocolImportance;
    }

    public String makeOptions() {
        StringBuffer options = new StringBuffer();
        if (this.getProtocolImportance() == null && this.getProtocol() == null && this.getMicAlgorithmImportance() == null && this.getMicAlgorithm() == null) {
            return new String("");
        }
        options.append("signed-receipt-protocol=").append(this.getProtocolImportance());
        options.append(", ").append(this.getProtocol());
        options.append("; signed-receipt-micalg=").append(this.getMicAlgorithmImportance());
        options.append(", ").append(this.getMicAlgorithm());
        return options.toString();
    }

    public void parseOptions(String options) throws OpenAS2Exception {
        this.setProtocolImportance(null);
        this.setProtocol(null);
        this.setMicAlgorithmImportance(null);
        this.setMicAlgorithm(null);
        if (options != null) {
            try {
                StringTokenizer optionTokens = new StringTokenizer(options, "=,;", false);
                if (optionTokens.countTokens() > 5) {
                    optionTokens.nextToken();
                    this.setProtocolImportance(optionTokens.nextToken().trim());
                    this.setProtocol(optionTokens.nextToken().trim());
                    optionTokens.nextToken();
                    this.setMicAlgorithmImportance(optionTokens.nextToken().trim());
                    this.setMicAlgorithm(optionTokens.nextToken().trim());
                }
            }
            catch (NoSuchElementException nsee) {
                throw new OpenAS2Exception("Invalid disposition options format: " + options);
            }
        }
    }

    public String toString() {
        return this.makeOptions();
    }
}

