/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.cert;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.openas2.lib.cert.CertificateException;
import org.openas2.lib.cert.ICertificateStore;
import org.openas2.lib.util.GeneralUtil;

public class KeyStore
implements ICertificateStore {
    private java.security.KeyStore keyStore;

    public KeyStore(java.security.KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public String[] getAliases() throws CertificateException {
        try {
            return GeneralUtil.convert(this.getKeyStore().aliases());
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error getting aliases", kse);
        }
    }

    @Override
    public Certificate getCertificate(String alias) throws CertificateException {
        try {
            return this.getKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error getting certificate for alias: " + alias, kse);
        }
    }

    @Override
    public void setCertificate(String alias, Certificate cert) throws CertificateException {
        try {
            this.getKeyStore().setCertificateEntry(alias, cert);
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error setting certificate: " + alias, kse);
        }
    }

    @Override
    public String getAlias(Certificate cert) throws CertificateException {
        try {
            return this.getKeyStore().getCertificateAlias(cert);
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error getting alias for certificate: " + cert.toString(), kse);
        }
    }

    @Override
    public void removeCertificate(String alias) throws CertificateException {
        try {
            this.getKeyStore().deleteEntry(alias);
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error while removing certificate: " + alias, kse);
        }
    }

    @Override
    public void clearCertificates() throws CertificateException {
        try {
            java.security.KeyStore ks = this.getKeyStore();
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                ks.deleteEntry(aliases.nextElement());
            }
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error clearing certificates", kse);
        }
    }

    @Override
    public Key getKey(String alias, char[] password) throws CertificateException {
        try {
            return this.getKeyStore().getKey(alias, password);
        }
        catch (GeneralSecurityException gse) {
            throw new CertificateException("Error getting key for alias: " + alias, gse);
        }
    }

    @Override
    public void setKey(String alias, Key key, char[] password) throws CertificateException {
        java.security.KeyStore ks = this.getKeyStore();
        try {
            Certificate[] certChain = ks.getCertificateChain(alias);
            ks.setKeyEntry(alias, key, password, certChain);
        }
        catch (KeyStoreException kse) {
            throw new CertificateException("Error setting key for alias: " + alias, kse);
        }
    }

    public java.security.KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(java.security.KeyStore keyStore) {
        this.keyStore = keyStore;
    }
}

