/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib;

import java.security.Key;
import java.security.cert.Certificate;
import org.openas2.lib.CryptoException;
import org.openas2.lib.EngineResults;
import org.openas2.lib.MDNEngine;
import org.openas2.lib.MDNException;
import org.openas2.lib.OpenAS2Exception;
import org.openas2.lib.cert.ICertificateChooser;
import org.openas2.lib.helper.EDIINTHelper;
import org.openas2.lib.message.EDIINTMessage;
import org.openas2.lib.message.EDIINTMessageMDN;
import org.openas2.lib.partner.IPartnership;
import org.openas2.lib.partner.IPartnershipChooser;
import org.openas2.lib.partner.PartnerException;

public class EDIINTEngine {
    private EDIINTHelper ediintHelper;
    private ICertificateChooser certificateChooser;
    private IPartnershipChooser partnershipChooser;
    private MDNEngine mdnEngine;

    public EDIINTEngine(EDIINTHelper ediintHelper, ICertificateChooser certificateChooser, IPartnershipChooser partnershipChooser) {
        this.ediintHelper = ediintHelper;
        this.certificateChooser = certificateChooser;
        this.partnershipChooser = partnershipChooser;
        this.mdnEngine = new MDNEngine(ediintHelper, certificateChooser, partnershipChooser);
    }

    public EDIINTEngine(EDIINTHelper ediintHelper, ICertificateChooser certificateChooser, IPartnershipChooser partnershipChooser, MDNEngine mdnEngine) {
        this.ediintHelper = ediintHelper;
        this.certificateChooser = certificateChooser;
        this.partnershipChooser = partnershipChooser;
        this.mdnEngine = mdnEngine;
    }

    public EngineResults encode(EDIINTMessage msg) {
        EngineResults results = new EngineResults();
        EDIINTHelper ediintHelper = this.getEDIINTHelper();
        ICertificateChooser certChooser = this.getCertificateChooser();
        IPartnership partnership = null;
        try {
            partnership = this.getPartnershipChooser().getPartnership(msg);
            results.setPartnership(partnership);
        }
        catch (PartnerException pe) {
            results.setException(pe);
            return results;
        }
        try {
            String signAlg = partnership.getSignatureAlgorithm();
            if (signAlg != null) {
                Certificate senderCert = certChooser.getSenderCertificate(msg);
                Key senderKey = certChooser.getSenderKey(msg);
                if (senderCert == null) {
                    throw new CryptoException("Sign failed: Certificate not found");
                }
                if (senderKey == null) {
                    throw new CryptoException("Sign failed: Private key not found");
                }
                ediintHelper.sign(msg, senderCert, senderKey, signAlg);
                results.setSignature(1);
            }
        }
        catch (OpenAS2Exception oae) {
            results.setSignature(2);
            results.setException(oae);
            return results;
        }
        try {
            String encryptionAlg = partnership.getEncryptionAlgorithm();
            if (encryptionAlg != null) {
                Certificate receiverCert = certChooser.getReceiverCertificate(msg);
                if (receiverCert == null) {
                    throw new CryptoException("Encryption failed: Certificate not found");
                }
                ediintHelper.encrypt(msg, receiverCert, encryptionAlg);
                results.setEncryption(1);
            }
        }
        catch (OpenAS2Exception oae) {
            results.setEncryption(2);
            results.setException(oae);
            return results;
        }
        return results;
    }

    public EngineResults decode(EDIINTMessage msg) {
        EngineResults results = new EngineResults();
        EDIINTHelper ediintHelper = this.getEDIINTHelper();
        ICertificateChooser certChooser = this.getCertificateChooser();
        IPartnership partnership = null;
        try {
            partnership = this.getPartnershipChooser().getPartnership(msg);
            results.setPartnership(partnership);
        }
        catch (PartnerException pe) {
            results.setException(pe);
            return results;
        }
        try {
            if (ediintHelper.isEncrypted(msg)) {
                Certificate receiverCert = certChooser.getReceiverCertificate(msg);
                Key receiverKey = certChooser.getReceiverKey(msg);
                if (receiverCert == null) {
                    throw new CryptoException("Decryption failed: Certificate not found");
                }
                if (receiverKey == null) {
                    throw new CryptoException("Decryption failed: Private key not found");
                }
                ediintHelper.decrypt(msg, receiverCert, receiverKey);
                results.setEncryption(1);
            }
        }
        catch (OpenAS2Exception oae) {
            results.setEncryption(2);
            results.setException(oae);
            return results;
        }
        try {
            if (ediintHelper.isSigned(msg)) {
                Certificate senderCert = certChooser.getSenderCertificate(msg);
                if (senderCert == null) {
                    throw new CryptoException("Signature verification failed: Certificate not found");
                }
                ediintHelper.verify(msg, senderCert);
                results.setSignature(1);
            }
        }
        catch (OpenAS2Exception oae) {
            results.setSignature(2);
            results.setException(oae);
            return results;
        }
        return results;
    }

    public EDIINTMessageMDN generateMDN(EDIINTMessage msg, EngineResults results) throws MDNException {
        MDNEngine mdnEngine = this.getMDNEngine();
        if (mdnEngine == null) {
            throw new MDNException("MDN Engine not set");
        }
        return mdnEngine.generateMDN(msg, results);
    }

    public EDIINTHelper getEDIINTHelper() {
        return this.ediintHelper;
    }

    public void setEDIINTHelper(EDIINTHelper ediintHelper) {
        this.ediintHelper = ediintHelper;
    }

    public ICertificateChooser getCertificateChooser() {
        return this.certificateChooser;
    }

    public void setCertificateChooser(ICertificateChooser certificateChooser) {
        this.certificateChooser = certificateChooser;
    }

    public IPartnershipChooser getPartnershipChooser() {
        return this.partnershipChooser;
    }

    public void setPartnershipChooser(IPartnershipChooser partnershipChooser) {
        this.partnershipChooser = partnershipChooser;
    }

    public MDNEngine getMDNEngine() {
        return this.mdnEngine;
    }

    public void setMDNEngine(MDNEngine mdnEngine) {
        this.mdnEngine = mdnEngine;
    }
}

