/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.message.Message;
import org.openas2.util.Profiler;
import org.openas2.util.ProfilerStub;
import org.openas2.util.Properties;
import org.openas2.util.ResponseWrapper;
import org.openas2.util.StringUtil;

public class HTTPUtil {
    public static final String MA_HTTP_REQ_TYPE = "HTTP_REQUEST_TYPE";
    public static final String MA_HTTP_REQ_URL = "HTTP_REQUEST_URL";
    public static final String HTTP_PROP_REMOVE_HEADER_FOLDING = "remove_http_header_folding";
    public static final String HTTP_PROP_SSL_PROTOCOLS = "http_ssl_protocols";
    public static final String HTTP_PROP_OVERRIDE_SSL_CHECKS = "http_override_ssl_checks";
    public static final String PARAM_READ_TIMEOUT = "readtimeout";
    public static final String PARAM_CONNECT_TIMEOUT = "connecttimeout";
    public static final String PARAM_SOCKET_TIMEOUT = "sockettimeout";
    public static final String PARAM_HTTP_USER = "http_user";
    public static final String PARAM_HTTP_PWD = "http_password";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_CONNECTION = "Connection";
    private static final Map<Integer, String> httpResponseCodeToPhrase = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(100, "Continue");
            this.put(101, "Switching Protocols");
            this.put(200, "OK");
            this.put(201, "Created");
            this.put(202, "Accepted");
            this.put(203, "Non-Authoritative Information");
            this.put(204, "No Content");
            this.put(205, "Reset Content");
            this.put(206, "Partial Content");
            this.put(300, "Multiple Choices");
            this.put(301, "Moved Permanently");
            this.put(302, "Found");
            this.put(303, "See Other");
            this.put(304, "Not Modified");
            this.put(305, "Use Proxy");
            this.put(307, "Temporary Redirect");
            this.put(400, "Bad Request");
            this.put(401, "Unauthorized");
            this.put(402, "Payment Required");
            this.put(403, "Forbidden");
            this.put(404, "Not Found");
            this.put(405, "Method Not Allowed");
            this.put(406, "Not Acceptable");
            this.put(407, "Proxy Authentication Required");
            this.put(408, "Request Time-out");
            this.put(409, "Conflict");
            this.put(410, "Gone");
            this.put(411, "Length Required");
            this.put(412, "Precondition Failed");
            this.put(413, "Request Entity Too Large");
            this.put(414, "Request-URI Too Large");
            this.put(415, "Unsupported Media Type");
            this.put(416, "Requested range not satisfiable");
            this.put(417, "Expectation Failed");
            this.put(500, "Internal Server Error");
            this.put(501, "Not Implemented");
            this.put(502, "Bad Gateway");
            this.put(503, "Service Unavailable");
            this.put(504, "Gateway Time-out");
            this.put(505, "HTTP Version not supported");
        }
    };

    public static String getHTTPResponseMessage(int responseCode) {
        String code = httpResponseCodeToPhrase.get(responseCode);
        return code == null ? "Unknown" : code;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] readHTTP(InputStream inStream, OutputStream outStream, InternetHeaders headerCache, List<String> httpRequest) throws IOException, MessagingException {
        byte[] data = null;
        Log logger = LogFactory.getLog((String)HTTPUtil.class.getSimpleName());
        BufferedInputStream in = new BufferedInputStream(inStream);
        String[] request = HTTPUtil.readRequest(in);
        for (int i = 0; i < request.length; ++i) {
            httpRequest.add(request[i]);
        }
        headerCache.load((InputStream)in);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("HTTP received request: " + request[0] + "  " + request[1] + "\n\tHeaders: " + HTTPUtil.printHeaders(headerCache.getAllHeaders(), "==", ";;")));
        }
        DataInputStream dataIn = new DataInputStream(in);
        if (headerCache.getHeader("Content-Length") != null) {
            int contentSize = Integer.parseInt(headerCache.getHeader("Content-Length", ","));
            data = new byte[contentSize];
            dataIn.readFully(data);
            return data;
        }
        String transfer_encoding = headerCache.getHeader("Transfer-Encoding", ",");
        if (transfer_encoding == null) return null;
        if (!transfer_encoding.replaceAll("\\s+", "").equalsIgnoreCase("chunked")) {
            if (outStream == null) throw new IOException("Transfer-Encoding unimplemented: " + transfer_encoding);
            HTTPUtil.sendHTTPResponse(outStream, 411, null);
            throw new IOException("Transfer-Encoding unimplemented: " + transfer_encoding);
        }
        int length = 0;
        data = null;
        block1: while (true) {
            int blocklen;
            block14: {
                blocklen = 0;
                while (true) {
                    int ch;
                    if ((ch = dataIn.readByte()) == 10) {
                        if (blocklen == 0) {
                            break;
                        }
                        break block14;
                    }
                    if (ch >= 97 && ch <= 102) {
                        ch -= 87;
                    } else if (ch >= 65 && ch <= 70) {
                        ch -= 55;
                    } else {
                        if (ch < 48 || ch > 57) continue;
                        ch -= 48;
                    }
                    blocklen = blocklen * 16 + ch;
                }
                headerCache.setHeader("Content-Length", Integer.toString(length));
                return data;
            }
            int newlen = length + blocklen;
            byte[] newdata = new byte[newlen];
            if (length > 0) {
                System.arraycopy(data, 0, newdata, 0, length);
            }
            dataIn.readFully(newdata, length, blocklen);
            data = newdata;
            length = newlen;
            while (true) {
                if (dataIn.readByte() == 10) continue block1;
            }
            break;
        }
    }

    public static byte[] readData(InputStream inStream, OutputStream outStream, Message msg) throws IOException, MessagingException {
        ArrayList<String> request = new ArrayList<String>(2);
        byte[] data = HTTPUtil.readHTTP(inStream, outStream, msg.getHeaders(), request);
        msg.setAttribute(MA_HTTP_REQ_TYPE, (String)request.get(0));
        msg.setAttribute(MA_HTTP_REQ_URL, (String)request.get(1));
        if (data == null) {
            String healthCheckUri = Properties.getProperty("health_check_uri", "healthcheck");
            if ("GET".equalsIgnoreCase((String)request.get(0)) && ((String)request.get(1)).matches("^[/]{0,1}" + healthCheckUri + "*")) {
                if (outStream != null) {
                    HTTPUtil.sendHTTPResponse(outStream, 200, null);
                    msg.setAttribute("isHealthCheck", "true");
                }
                return null;
            }
            HTTPUtil.sendHTTPResponse(outStream, 411, null);
            Log logger = LogFactory.getLog((String)HTTPUtil.class.getSimpleName());
            logger.error((Object)("Inbound HTTP request does not provide means to determine data length: " + (String)request.get(0) + " " + (String)request.get(1) + "\n\tHeaders: " + HTTPUtil.printHeaders(msg.getHeaders().getAllHeaders(), "==", ";;")));
            throw new IOException("Content-Length missing and no \"Transfer-Encoding\" header found to determine how to read message body.");
        }
        HTTPUtil.cleanIdHeaders(msg.getHeaders());
        return data;
    }

    public static void cleanIdHeaders(InternetHeaders hdrs) {
        String[] idHeaders = new String[]{"AS2-From", "AS2-To"};
        for (int i = 0; i < idHeaders.length; ++i) {
            String value = StringUtil.removeDoubleQuotes(hdrs.getHeader(idHeaders[i], null));
            hdrs.removeHeader(idHeaders[i]);
            hdrs.setHeader(idHeaders[i], value);
        }
    }

    public static String[] readRequest(InputStream in) throws IOException {
        StringTokenizer tokens;
        int tokenCount;
        int byteBuf = in.read();
        StringBuffer strBuf = new StringBuffer();
        while (byteBuf != -1 && byteBuf != 13) {
            strBuf.append((char)byteBuf);
            byteBuf = in.read();
        }
        if (byteBuf != -1) {
            in.read();
        }
        if ((tokenCount = (tokens = new StringTokenizer(strBuf.toString(), " ")).countTokens()) >= 3) {
            String[] requestParts = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                requestParts[i] = tokens.nextToken();
            }
            return requestParts;
        }
        if (tokenCount == 2) {
            String[] requestParts = new String[]{tokens.nextToken(), "/", tokens.nextToken()};
            return requestParts;
        }
        throw new IOException("Invalid HTTP Request: Token Count - " + tokenCount + "::: String length - " + strBuf.length() + " ::: String - " + strBuf.toString());
    }

    public static ResponseWrapper execRequest(String method, String url, Enumeration<javax.mail.Header> headers, NameValuePair[] params, InputStream inputStream, Map<String, String> options, long noChunkMaxSize) throws Exception {
        HttpClientBuilder httpBuilder = HttpClientBuilder.create();
        URL urlObj = new URL(url);
        if (urlObj.getProtocol().equalsIgnoreCase("https")) {
            SSLConnectionSocketFactory sslCsf = HTTPUtil.buildSslFactory(urlObj, options);
            httpBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslCsf).build()));
        } else {
            httpBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager());
        }
        RequestBuilder rb = HTTPUtil.getRequestBuilder(method, urlObj, params, headers);
        RequestConfig.Builder rcBuilder = HTTPUtil.buildRequestConfig(options);
        HTTPUtil.setProxyConfig(httpBuilder, rcBuilder, urlObj.getProtocol());
        rb.setConfig(rcBuilder.build());
        String httpUser = options.get(PARAM_HTTP_USER);
        String httpPwd = options.get(PARAM_HTTP_PWD);
        if (httpUser != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(httpUser, httpPwd));
            httpBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (inputStream != null) {
            if (noChunkMaxSize > 0L) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                long copied = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)bout, (long)0L, (long)(noChunkMaxSize + 1L), (byte[])new byte[8192]);
                if (copied > noChunkMaxSize) {
                    throw new IOException("Mime inputstream too big to put in memory (more than " + noChunkMaxSize + " bytes).");
                }
                ByteArrayEntity bae = new ByteArrayEntity(bout.toByteArray(), null);
                rb.setEntity((HttpEntity)bae);
            } else {
                InputStreamEntity ise = new InputStreamEntity(inputStream);
                if (httpUser != null) {
                    rb.setEntity((HttpEntity)new BufferedHttpEntity((HttpEntity)ise));
                } else {
                    rb.setEntity((HttpEntity)ise);
                }
            }
        }
        HttpUriRequest request = rb.build();
        BasicHttpContext localcontext = new BasicHttpContext();
        BasicScheme basicAuth = new BasicScheme();
        localcontext.setAttribute("preemptive-auth", (Object)basicAuth);
        try (CloseableHttpClient httpClient = httpBuilder.build();){
            ResponseWrapper throwable2;
            block22: {
                ProfilerStub transferStub = Profiler.startProfile();
                CloseableHttpResponse response = httpClient.execute(request, (HttpContext)localcontext);
                try {
                    ResponseWrapper resp = new ResponseWrapper((HttpResponse)response);
                    Profiler.endProfile(transferStub);
                    resp.setTransferTimeMs(transferStub.getMilliseconds());
                    for (Header header : response.getAllHeaders()) {
                        resp.addHeaderLine(header.toString());
                    }
                    throwable2 = resp;
                    if (response == null) break block22;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return throwable2;
        }
    }

    private static SSLConnectionSocketFactory buildSslFactory(URL urlObj, Map<String, String> options) throws Exception {
        SSLContext sslcontext;
        boolean overrideSslChecks = "true".equalsIgnoreCase(options.get(HTTP_PROP_OVERRIDE_SSL_CHECKS));
        String selfSignedCN = System.getProperty("org.openas2.cert.TrustSelfSignedCN");
        if (selfSignedCN != null && selfSignedCN.contains(urlObj.getHost()) || overrideSslChecks) {
            File file = HTTPUtil.getTrustedCertsKeystore();
            KeyStore ks = null;
            try (FileInputStream in = new FileInputStream(file);){
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(in, "changeit".toCharArray());
            }
            try {
                sslcontext = SSLContexts.custom().loadTrustMaterial(ks, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            }
            catch (Exception e) {
                throw new OpenAS2Exception("Self-signed certificate URL connection failed connecting to : " + urlObj.toString(), e);
            }
        }
        sslcontext = SSLContexts.createSystemDefault();
        HostnameVerifier hnv = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        if (overrideSslChecks) {
            hnv = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, null, null, hnv);
        return sslsf;
    }

    private static RequestBuilder getRequestBuilder(String method, URL urlObj, NameValuePair[] params, Enumeration<javax.mail.Header> headers) throws URISyntaxException {
        RequestBuilder req = null;
        if (method == null || method.equalsIgnoreCase("GET")) {
            req = RequestBuilder.get();
        } else if (method.equalsIgnoreCase("POST")) {
            req = RequestBuilder.post();
        } else if (method.equalsIgnoreCase("HEAD")) {
            req = RequestBuilder.head();
        } else if (method.equalsIgnoreCase("PUT")) {
            req = RequestBuilder.put();
        } else if (method.equalsIgnoreCase("DELETE")) {
            req = RequestBuilder.delete();
        } else if (method.equalsIgnoreCase("TRACE")) {
            req = RequestBuilder.trace();
        } else {
            throw new IllegalArgumentException("Illegal HTTP Method: " + method);
        }
        req.setUri(urlObj.toURI());
        if (params != null && params.length > 0) {
            req.addParameters(params);
        }
        if (headers != null) {
            boolean removeHeaderFolding = "true".equals(Properties.getProperty(HTTP_PROP_REMOVE_HEADER_FOLDING, "true"));
            while (headers.hasMoreElements()) {
                javax.mail.Header header = headers.nextElement();
                String headerValue = header.getValue();
                if (removeHeaderFolding) {
                    headerValue = headerValue.replaceAll("\r\n[ \t]*", " ");
                }
                req.setHeader(header.getName(), headerValue);
            }
        }
        return req;
    }

    private static RequestConfig.Builder buildRequestConfig(Map<String, String> options) {
        String connectTimeOutStr = options.get(PARAM_CONNECT_TIMEOUT);
        String readTimeOutStr = options.get(PARAM_READ_TIMEOUT);
        String socketTimeOutStr = options.get(PARAM_SOCKET_TIMEOUT);
        RequestConfig.Builder rcBuilder = RequestConfig.custom();
        if (connectTimeOutStr != null) {
            rcBuilder.setConnectTimeout(Integer.parseInt(connectTimeOutStr));
        }
        if (readTimeOutStr != null) {
            rcBuilder.setConnectionRequestTimeout(Integer.parseInt(readTimeOutStr));
        }
        if (socketTimeOutStr != null) {
            rcBuilder.setSocketTimeout(Integer.parseInt(socketTimeOutStr));
        }
        return rcBuilder;
    }

    public static void sendHTTPResponse(OutputStream out, int responseCode, ByteArrayOutputStream data, Enumeration<String> headers) throws IOException {
        StringBuffer httpResponse = new StringBuffer();
        httpResponse.append(responseCode).append(" ");
        httpResponse.append(HTTPUtil.getHTTPResponseMessage(responseCode));
        httpResponse.append("\r\n");
        StringBuffer response = new StringBuffer("HTTP/1.1 ");
        response.append(httpResponse);
        out.write(response.toString().getBytes());
        if (headers != null) {
            boolean removeHeaderFolding = "true".equals(Properties.getProperty(HTTP_PROP_REMOVE_HEADER_FOLDING, "true"));
            while (headers.hasMoreElements()) {
                String header = headers.nextElement();
                if (removeHeaderFolding) {
                    header = header.replaceAll("\r\n[ \t]*", " ");
                }
                out.write((header + "\r\n").getBytes());
            }
        }
        if (data == null || data.size() < 1) {
            boolean sendHttpCodeAsString = "true".equals(Properties.getProperty("send_http_code_as_string_when_no_data", "true"));
            if (sendHttpCodeAsString) {
                byte[] responseCodeBytes = httpResponse.toString().getBytes();
                out.write(("Content-Length: " + responseCodeBytes.length + "\r\n\r\n").getBytes());
                out.write(responseCodeBytes);
            } else {
                out.write("Content-Length: 0\r\n\r\n".getBytes());
            }
        } else {
            out.write("\r\n".getBytes());
            data.writeTo(out);
        }
        out.flush();
    }

    public static void sendHTTPResponse(OutputStream out, int responseCode, String data) throws IOException {
        ByteArrayOutputStream dataOS = null;
        if (data != null) {
            dataOS = new ByteArrayOutputStream();
            dataOS.write(data.getBytes());
        }
        HTTPUtil.sendHTTPResponse(out, responseCode, dataOS, null);
    }

    public static String printHeaders(Enumeration<javax.mail.Header> hdrs, String nameValueSeparator, String valuePairSeparator) {
        String headers = "";
        while (hdrs.hasMoreElements()) {
            javax.mail.Header h = hdrs.nextElement();
            headers = headers + valuePairSeparator + h.getName() + nameValueSeparator + h.getValue();
        }
        return headers;
    }

    public static File getTrustedCertsKeystore() throws OpenAS2Exception {
        File file = new File("jssecacerts");
        if (!file.isFile()) {
            char SEP = File.separatorChar;
            File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
            if (!dir.isDirectory()) {
                dir = new File(System.getProperty("java.home") + SEP + "jre" + SEP + "lib" + SEP + "security");
            }
            if (!dir.isDirectory()) {
                throw new OpenAS2Exception("The JSSE folder could not be identified. Please check that JSSE is installed.");
            }
            file = new File(dir, "jssecacerts");
            if (!file.isFile()) {
                file = new File(dir, "cacerts");
            }
        }
        return file;
    }

    public static String getParamsString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            result.append("&");
        }
        String resultString = result.toString();
        return resultString.length() > 0 ? resultString.substring(0, resultString.length() - 1) : resultString;
    }

    public static boolean isLocalhostBound(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    public static HttpURLConnection getConnection(String url, boolean output, boolean input, boolean useCaches, String requestMethod) throws OpenAS2Exception {
        if (url == null) {
            throw new OpenAS2Exception("HTTP getConnection method received empty URL string.");
        }
        try {
            HttpURLConnection conn;
            HTTPUtil.initializeProxyAuthenticator();
            URL urlObj = new URL(url);
            if (urlObj.getProtocol().equalsIgnoreCase("https")) {
                HttpsURLConnection connS = (HttpsURLConnection)urlObj.openConnection(HTTPUtil.getProxy("https"));
                String selfSignedCN = System.getProperty("org.openas2.cert.TrustSelfSignedCN");
                if (selfSignedCN != null) {
                    File file = new File("jssecacerts");
                    if (!file.isFile()) {
                        char SEP = File.separatorChar;
                        File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
                        if (!dir.isDirectory()) {
                            dir = new File(System.getProperty("java.home") + SEP + "jre" + SEP + "lib" + SEP + "security");
                        }
                        if (!dir.isDirectory()) {
                            throw new OpenAS2Exception("The JSSE folder could not be identified. Please check that JSSE is installed.");
                        }
                        file = new File(dir, "jssecacerts");
                        if (!file.isFile()) {
                            file = new File(dir, "cacerts");
                        }
                    }
                    FileInputStream in = new FileInputStream(file);
                    try {
                        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                        ks.load(in, "changeit".toCharArray());
                        ((InputStream)in).close();
                        SSLContext context = SSLContext.getInstance("TLS");
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(ks);
                        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                        SelfSignedTrustManager tm = new SelfSignedTrustManager(defaultTrustManager);
                        tm.setTrustCN(selfSignedCN);
                        context.init(null, new TrustManager[]{tm}, null);
                        connS.setSSLSocketFactory(context.getSocketFactory());
                    }
                    catch (Exception e) {
                        throw new OpenAS2Exception("Self-signed certificate URL connection failed connecting to : " + url, e);
                    }
                }
                conn = connS;
            } else {
                conn = (HttpURLConnection)urlObj.openConnection(HTTPUtil.getProxy("http"));
            }
            conn.setDoOutput(output);
            conn.setDoInput(input);
            conn.setUseCaches(useCaches);
            conn.setRequestMethod(requestMethod);
            return conn;
        }
        catch (IOException ioe) {
            throw new WrappedException("URL connection failed connecting to: " + url, ioe);
        }
    }

    private static void setProxyConfig(HttpClientBuilder builder, RequestConfig.Builder rcBuilder, String protocol) throws OpenAS2Exception {
        String proxyUser;
        String proxyHost = Properties.getProperty(protocol + ".proxyHost", null);
        if (proxyHost == null) {
            proxyHost = System.getProperty(protocol + ".proxyHost");
        }
        if (proxyHost == null) {
            return;
        }
        String proxyPort = Properties.getProperty(protocol + ".proxyPort", null);
        if (proxyPort == null) {
            proxyPort = System.getProperty(protocol + ".proxyPort");
        }
        if (proxyPort == null) {
            throw new OpenAS2Exception("Missing PROXY port since Proxy host is set");
        }
        int port = Integer.parseInt(proxyPort);
        HttpHost proxy = new HttpHost(proxyHost, port);
        rcBuilder.setProxy(proxy);
        String proxyUser1 = Properties.getProperty("http.proxyUser", null);
        String string = proxyUser = proxyUser1 == null ? System.getProperty("http.proxyUser") : proxyUser1;
        if (proxyUser == null) {
            return;
        }
        String proxyPwd1 = Properties.getProperty("http.proxyPassword", null);
        String proxyPassword = proxyPwd1 == null ? System.getProperty("http.proxyPassword") : proxyPwd1;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxyHost, port), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
    }

    private static Proxy getProxy(String protocol) throws OpenAS2Exception {
        String proxyHost = Properties.getProperty(protocol + ".proxyHost", null);
        if (proxyHost == null) {
            proxyHost = System.getProperty(protocol + ".proxyHost");
        }
        if (proxyHost == null) {
            return Proxy.NO_PROXY;
        }
        String proxyPort = Properties.getProperty(protocol + ".proxyPort", null);
        if (proxyPort == null) {
            proxyPort = System.getProperty(protocol + ".proxyPort");
        }
        if (proxyPort == null) {
            throw new OpenAS2Exception("Missing PROXY port since Proxy host is set");
        }
        int port = Integer.parseInt(proxyPort);
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, port));
    }

    private static void initializeProxyAuthenticator() {
        String proxyPassword;
        String proxyUser1 = Properties.getProperty("http.proxyUser", null);
        final String proxyUser = proxyUser1 == null ? System.getProperty("http.proxyUser") : proxyUser1;
        String proxyPwd1 = Properties.getProperty("http.proxyPassword", null);
        String string = proxyPassword = proxyPwd1 == null ? System.getProperty("http.proxyPassword") : proxyPwd1;
        if (proxyUser != null && proxyPassword != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                }
            });
        }
    }

    public static void copyHttpHeaders(HttpURLConnection conn, InternetHeaders headers) {
        for (Map.Entry<String, List<String>> connHeader : conn.getHeaderFields().entrySet()) {
            String headerName = connHeader.getKey();
            if (headerName == null) continue;
            for (String value : connHeader.getValue()) {
                String[] existingVals = headers.getHeader(headerName);
                if (existingVals == null) {
                    headers.setHeader(headerName, value);
                    continue;
                }
                boolean exists = false;
                for (int i = 0; i < existingVals.length; ++i) {
                    if (!value.equals(existingVals[i])) continue;
                    exists = true;
                }
                if (exists) continue;
                headers.addHeader(headerName, value);
            }
        }
    }

    private static class SelfSignedTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private String[] trustCN = null;

        SelfSignedTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.tm.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (chain.length == 1) {
                String dn = chain[0].getIssuerDN().getName();
                for (int i = 0; i < this.trustCN.length; ++i) {
                    if (!dn.contains("CN=" + this.trustCN[i])) continue;
                    return;
                }
            }
            this.tm.checkServerTrusted(chain, authType);
        }

        public void setTrustCN(String trustCN) {
            this.trustCN = trustCN.split(",");
        }
    }

    public static abstract class Method {
        public static final String GET = "GET";
        public static final String HEAD = "HEAD";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
        public static final String TRACE = "TRACE";
        public static final String CONNECT = "CONNECT";
    }
}

