/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.sender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.ComponentNotFoundException;
import org.openas2.OpenAS2Exception;
import org.openas2.cert.CertificateFactory;
import org.openas2.message.AS2Message;
import org.openas2.message.AS2MessageMDN;
import org.openas2.message.DataHistoryItem;
import org.openas2.message.Message;
import org.openas2.params.CompositeParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.partner.Partnership;
import org.openas2.processor.sender.HttpResponseException;
import org.openas2.processor.sender.HttpSenderModule;
import org.openas2.schedule.HasSchedule;
import org.openas2.util.AS2Util;
import org.openas2.util.DateUtil;
import org.openas2.util.DispositionOptions;
import org.openas2.util.HTTPUtil;
import org.openas2.util.IOUtil;
import org.openas2.util.Properties;
import org.openas2.util.ResponseWrapper;

public class AS2SenderModule
extends HttpSenderModule
implements HasSchedule {
    private Log logger = LogFactory.getLog((String)AS2SenderModule.class.getSimpleName());

    @Override
    public boolean canHandle(String action, Message msg, Map<Object, Object> options) {
        if (!action.equals("send")) {
            return false;
        }
        return msg instanceof AS2Message;
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        MimeBodyPart securedData;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("message sender invoked" + msg.getLogMsgID()));
        }
        boolean isResend = "resending_msg".equals(msg.getStatus());
        options.put("DIRECTION", "SEND");
        options.put("IS_RESEND", isResend ? "Y" : "N");
        if (!(msg instanceof AS2Message)) {
            throw new OpenAS2Exception("Can't send non-AS2 message");
        }
        this.checkRequired(msg);
        if (options != null) {
            msg.getOptions().putAll(options);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Retry count from options: " + options));
        }
        String retries = AS2Util.retries(options, this.getParameter("retries", false));
        this.addCustomHeaders(msg);
        try {
            securedData = this.secure(msg);
            this.addCustomOuterMimeHeaders(msg, securedData);
            this.storePendingInfo((AS2Message)msg, isResend);
        }
        catch (Exception e) {
            msg.setLogMsg(org.openas2.logging.Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            msg.setOption("STATE", "msg_send_exception");
            msg.trackMsgState(this.getSession());
            throw new OpenAS2Exception("Error setting up message for sending.", e);
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message object in sender module. Content-Disposition: " + msg.getContentDisposition() + "\n      Content-Type : " + msg.getContentType() + "\n      HEADERS : " + AS2Util.printHeaders(msg.getData().getAllHeaders()) + "\n      Content-Disposition in MSG getData() MIMEPART: " + msg.getData().getContentType() + msg.getLogMsgID()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String url = msg.getPartnership().getAttribute("as2_url");
        CompositeParameters params = new CompositeParameters(false).add("msg", new MessageParameters(msg));
        url = ParameterParser.parse(url, params);
        try {
            msg.setOption("STATE", "msg_send_start");
            msg.trackMsgState(this.getSession());
            this.sendMessage(url, msg, securedData, retries);
        }
        catch (HttpResponseException hre) {
            this.resend(msg, hre, retries, false);
            msg.setOption("STATE", "msg_send_exception");
            msg.trackMsgState(this.getSession());
            return;
        }
        catch (SSLHandshakeException e) {
            msg.setLogMsg("Failed to connect to partner using SSL certificate. Please run the SSL certificate checker utility to identify the issue: " + url);
            this.logger.error((Object)msg, (Throwable)e);
            msg.setOption("STATE", "msg_send_fail");
            msg.trackMsgState(this.getSession());
            return;
        }
        catch (Exception e) {
            msg.setLogMsg("Unexpected error sending file: " + org.openas2.logging.Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            this.resend(msg, new OpenAS2Exception(org.openas2.logging.Log.getExceptionMsg(e)), retries, false);
            msg.setOption("STATE", "msg_send_exception");
            msg.trackMsgState(this.getSession());
            return;
        }
    }

    protected void checkRequired(Message msg) throws InvalidParameterException {
        Partnership partnership = msg.getPartnership();
        try {
            InvalidParameterException.checkValue(msg, "ContentType", msg.getContentType());
            InvalidParameterException.checkValue(msg, "Attribute: as2_url", partnership.getAttribute("as2_url"));
            InvalidParameterException.checkValue(msg, "Receiver: as2_id", partnership.getReceiverID("as2_id"));
            InvalidParameterException.checkValue(msg, "Sender: as2_id", partnership.getSenderID("as2_id"));
            InvalidParameterException.checkValue(msg, "Subject", msg.getSubject());
            InvalidParameterException.checkValue(msg, "Sender: email", partnership.getSenderID("email"));
            InvalidParameterException.checkValue(msg, "Message Data", msg.getData());
        }
        catch (InvalidParameterException rpe) {
            rpe.addSource("message", msg);
            throw rpe;
        }
    }

    private void sendMessage(String url, Message msg, MimeBodyPart securedData, String retries) throws Exception {
        int rc;
        URL urlObj = new URL(url);
        InternetHeaders ih = this.getHttpHeaders(msg, securedData);
        msg.setAttribute("destination_ip", urlObj.getHost());
        msg.setAttribute("destination_port", Integer.toString(urlObj.getPort()));
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connecting to: " + url + msg.getLogMsgID()));
        }
        Map<String, String> httpOptions = this.getHttpOptions();
        httpOptions.put("http_user", msg.getPartnership().getAttribute("http_user"));
        httpOptions.put("http_password", msg.getPartnership().getAttribute("http_password"));
        long maxSize = msg.getPartnership().getNoChunkedMaxSize();
        ResponseWrapper resp = HTTPUtil.execRequest("POST", url, ih.getAllHeaders(), null, securedData.getInputStream(), httpOptions, maxSize);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Message sent and response received in " + resp.getTransferTimeMs() + "ms" + msg.getLogMsgID()));
        }
        if ((rc = resp.getStatusCode()) != 200 && rc != 201 && rc != 202 && rc != 206 && rc != 204) {
            msg.setLogMsg("Error sending message. URL: " + url + " ::: Response Code: " + rc + " " + resp.getStatusPhrase() + " ::: Response Message: " + resp.getBody().toString());
            this.logger.error((Object)msg);
            throw new HttpResponseException(url, rc, resp.getStatusPhrase());
        }
        this.processResponse(msg, resp);
    }

    private void processResponse(Message msg, ResponseWrapper response) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Message sent. Checking if MDN is expected..." + msg.getLogMsgID()));
        }
        if (!msg.isConfiguredForMDN()) {
            return;
        }
        if (msg.getPartnership().getAttribute("as2_receipt_option") != null) {
            msg.setStatus("awaiting_mdn");
        } else {
            AS2MessageMDN mdn = new AS2MessageMDN((AS2Message)msg, false);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("MDN msg initalised for inbound contains headers:" + AS2Util.printHeaders(mdn.getHeaders().getAllHeaders()) + msg.getLogMsgID()));
            }
            mdn.copyHeaders(response.getHeaders());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Synchronous MDN received. Start processing..." + msg.getLogMsgID()));
            }
            msg.setStatus("init_processing_mdn");
            try {
                AS2Util.processMDN((AS2Message)msg, response.getBody(), null, false, this.getSession(), this);
                msg.setOption("STATE", "msg_sent_mdn_received_ok");
                msg.trackMsgState(this.getSession());
            }
            catch (Exception e) {
                if ("init_processing_mdn".equals(msg.getStatus()) || "parsing_mdn".equals(msg.getStatus()) || !(e instanceof OpenAS2Exception)) {
                    msg.setLogMsg("Unhandled error condition processing synchronous MDN. Message and associated files cleanup will be attempted but may be in an unknown state.");
                    this.logger.error((Object)msg, (Throwable)e);
                } else {
                    msg.setLogMsg("Exception receiving synchronous MDN. Message and associated files cleanup will be attempted but may be in an unknown state.");
                    this.logger.error((Object)msg, (Throwable)e);
                }
                msg.setOption("STATE", "msg_send_fail");
                msg.trackMsgState(this.getSession());
                AS2Util.cleanupFiles(msg, true);
            }
        }
    }

    private void resend(Message msg, OpenAS2Exception cause, String tries, boolean keepRestoredData) throws OpenAS2Exception {
        AS2Util.resend(this.getSession(), this, "send", msg, cause, tries, false, keepRestoredData);
    }

    protected MimeBodyPart secure(Message msg) throws Exception {
        String t;
        boolean sign;
        MimeBodyPart dataBP = msg.getData();
        Partnership partnership = msg.getPartnership();
        String contentTxfrEncoding = partnership.getAttribute("content_transfer_encoding");
        if (contentTxfrEncoding == null) {
            contentTxfrEncoding = "binary";
        }
        boolean encrypt = partnership.getAttribute("encrypt") != null;
        boolean bl = sign = partnership.getAttribute("sign") != null;
        if (!sign) {
            this.calcAndStoreMic(msg, dataBP, sign || encrypt);
        }
        String compressionType = msg.getPartnership().getAttribute("compression_type");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Compression type from config: " + compressionType));
        }
        boolean isCompress = false;
        if (compressionType != null && !"NONE".equalsIgnoreCase(compressionType)) {
            if (compressionType.equalsIgnoreCase("zlib")) {
                isCompress = true;
            } else {
                throw new OpenAS2Exception("Unsupported compression type: " + compressionType);
            }
        }
        String compressionMode = msg.getPartnership().getAttribute("compression_mode");
        boolean isCompressBeforeSign = true;
        if (compressionMode != null && compressionMode.equalsIgnoreCase("compress-after-signing")) {
            isCompressBeforeSign = false;
        }
        if (isCompress && isCompressBeforeSign) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Compressing outbound message before signing...");
            }
            if (!sign && !encrypt) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            dataBP = AS2Util.getCryptoHelper().compress(msg, dataBP, compressionType, contentTxfrEncoding);
        }
        CertificateFactory certFx = this.getSession().getCertificateFactory();
        if (sign) {
            if (!(encrypt || isCompress && !isCompressBeforeSign)) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            this.calcAndStoreMic(msg, dataBP, sign || encrypt);
            X509Certificate senderCert = certFx.getCertificate(msg, "sender");
            PrivateKey senderKey = certFx.getPrivateKey(msg, senderCert);
            String digest = partnership.getAttribute("sign");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Params for creating signed body part:: DATA: " + dataBP + "\n SIGN DIGEST: " + digest + "\n CERT ALG NAME EXTRACTED: " + senderCert.getSigAlgName() + "\n CERT PUB KEY ALG NAME EXTRACTED: " + senderCert.getPublicKey().getAlgorithm() + msg.getLogMsgID()));
            }
            boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(partnership.getAttribute("remove_cms_algorithm_protection_attrib"));
            dataBP = AS2Util.getCryptoHelper().sign(dataBP, senderCert, senderKey, digest, contentTxfrEncoding, msg.getPartnership().isRenameDigestToOldName(), isRemoveCmsAlgorithmProtectionAttr);
            DataHistoryItem historyItem = new DataHistoryItem(dataBP.getContentType());
            msg.getHistory().getItems().add(historyItem);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("signed data" + msg.getLogMsgID()));
            }
        }
        if (isCompress && !isCompressBeforeSign) {
            if (!encrypt) {
                this.addCustomOuterMimeHeaders(msg, dataBP);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Compressing outbound message after signing...");
            }
            dataBP = AS2Util.getCryptoHelper().compress(msg, dataBP, compressionType, contentTxfrEncoding);
        }
        if (encrypt) {
            this.addCustomOuterMimeHeaders(msg, dataBP);
            String algorithm = partnership.getAttribute("encrypt");
            X509Certificate receiverCert = certFx.getCertificate(msg, "receiver");
            dataBP = AS2Util.getCryptoHelper().encrypt(dataBP, receiverCert, algorithm, contentTxfrEncoding);
            DataHistoryItem historyItem = new DataHistoryItem(dataBP.getContentType());
            msg.getHistory().getItems().add(historyItem);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("encrypted data" + msg.getLogMsgID()));
            }
        }
        if (((t = dataBP.getEncoding()) == null || t.length() < 1) && "true".equalsIgnoreCase(partnership.getAttribute("set_content_transfer_encoding_on_outer_mime_bodypart"))) {
            dataBP.setHeader("Content-Transfer-Encoding", contentTxfrEncoding);
        }
        return dataBP;
    }

    protected void addCustomHeaders(Message msg) throws OpenAS2Exception {
        String customHeaders = msg.getPartnership().getAttribute("custom_mime_headers");
        if (customHeaders != null && customHeaders.length() > 0) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding custom header attribute to custom headers map..." + msg.getLogMsgID()));
            }
            String[] headers = customHeaders.split("\\s*;\\s*");
            for (int i = 0; i < headers.length; ++i) {
                String[] header = headers[i].split("\\s*:\\s*");
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Adding custom header: " + headers[i] + " :::Split count:" + header.length + msg.getLogMsgID()));
                }
                if (header.length != 2) {
                    throw new OpenAS2Exception("Invalid custom header: " + headers[i]);
                }
                msg.addCustomOuterMimeHeader(header[0].replaceAll(" ", ""), header[1]);
            }
        }
    }

    protected void addCustomOuterMimeHeaders(Message msg, MimeBodyPart dataBP) throws MessagingException {
        Map<String, String> hdrs;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Adding custom headers to outer MBP...." + msg.getLogMsgID()));
        }
        if ((hdrs = msg.getCustomOuterMimeHeaders()) == null) {
            return;
        }
        for (Map.Entry<String, String> entry : hdrs.entrySet()) {
            dataBP.addHeader(entry.getKey(), entry.getValue());
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Added custom headers to outer MBP: " + entry.getKey() + "--->" + entry.getValue() + msg.getLogMsgID()));
        }
    }

    protected InternetHeaders getHttpHeaders(Message msg, MimeBodyPart securedData) throws MessagingException {
        String contentDisp;
        String receiptOption;
        String dispOptions;
        Partnership partnership = msg.getPartnership();
        InternetHeaders ih = new InternetHeaders();
        ih.addHeader("Connection", "close, TE");
        String userAgent = Properties.getProperty("http.user.agent", msg.getAppTitle() + " (" + AS2SenderModule.class.getSimpleName() + ")");
        ih.addHeader("User-Agent", userAgent);
        ih.addHeader("Date", DateUtil.formatDate(Properties.getProperty("HTTP_HEADER_DATE_FORMAT", "EEE, dd MMM yyyy HH:mm:ss Z"), Locale.ENGLISH));
        ih.addHeader("Message-ID", msg.getMessageID());
        ih.addHeader("Mime-Version", "1.0");
        try {
            ih.addHeader("Content-Type", securedData.getContentType());
        }
        catch (MessagingException e) {
            ih.addHeader("Content-Type", msg.getContentType());
        }
        ih.addHeader("AS2-Version", "1.1");
        if ("true".equalsIgnoreCase(System.getProperty("sun.net.http.allowRestrictedHeaders", "false"))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"HTTP RESTRICTED HEADERS property is not active");
            }
            String cte = null;
            cte = msg.getPartnership().getAttributeOrProperty("content_transfer_encoding", null);
            if (cte != null && "true".equalsIgnoreCase(msg.getPartnership().getAttributeOrProperty("set_content_transfer_encoding_http_header", "false"))) {
                ih.addHeader("Content-Transfer-Encoding", cte);
            }
        }
        ih.addHeader("Recipient-Address", partnership.getAttribute("as2_url"));
        String rId = partnership.getReceiverID("as2_id");
        if (rId.contains(" ")) {
            rId = "\"" + rId + "\"";
        }
        ih.addHeader("AS2-To", rId);
        String sId = partnership.getSenderID("as2_id");
        if (sId.contains(" ")) {
            sId = "\"" + sId + "\"";
        }
        ih.addHeader("AS2-From", sId);
        ih.addHeader("Subject", msg.getSubject());
        ih.addHeader("From", partnership.getSenderID("email"));
        String dispTo = partnership.getAttribute("as2_mdn_to");
        if (dispTo != null) {
            ih.addHeader("Disposition-Notification-To", dispTo);
        }
        if ((dispOptions = partnership.getAttribute("as2_mdn_options")) != null && !"none".equalsIgnoreCase(dispOptions)) {
            ih.addHeader("Disposition-Notification-Options", dispOptions);
        }
        if ((receiptOption = partnership.getAttribute("as2_receipt_option")) != null) {
            ih.addHeader("Receipt-Delivery-Option", receiptOption);
        }
        try {
            contentDisp = securedData.getDisposition();
        }
        catch (MessagingException e) {
            contentDisp = msg.getContentDisposition();
        }
        if (contentDisp != null) {
            ih.addHeader("Content-Disposition", contentDisp);
        }
        if ("true".equalsIgnoreCase(partnership.getAttribute("add_custom_mime_headers_to_http"))) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding custom headers to HTTP..." + msg.getLogMsgID()));
            }
            for (Map.Entry<String, String> entry : msg.getCustomOuterMimeHeaders().entrySet()) {
                ih.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return ih;
    }

    protected void storePendingInfo(AS2Message msg, boolean isResend) throws Exception {
        ObjectOutputStream oos = null;
        try {
            String pendingInfoFile = AS2Util.buildPendingFileName(msg, this.getSession().getProcessor(), "pendingmdninfo");
            String pendingFile = msg.getAttribute("pendingfilename");
            msg.setAttribute("pendingfilename", pendingFile);
            msg.setAttribute("pendinginfo", pendingInfoFile);
            if (!isResend) {
                String pendingMsgObjFile = pendingFile + ".object";
                oos = new ObjectOutputStream(new FileOutputStream(pendingMsgObjFile));
                oos.writeObject(msg);
                oos.flush();
                oos.close();
            }
            oos = new ObjectOutputStream(new FileOutputStream(pendingInfoFile));
            oos.writeObject(msg.getCalculatedMIC());
            String retries = (String)msg.getOption("retries");
            oos.writeObject(retries == null ? "" : retries);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Save Original mic & message id information into file: " + pendingInfoFile + msg.getLogMsgID()));
            }
            oos.writeObject(msg.getPayloadFilename());
            oos.writeObject(msg.getAttribute("filename"));
            oos.writeObject(pendingFile);
            oos.writeObject(msg.getAttribute("errordir"));
            String sentDir = msg.getAttribute("sentdir");
            oos.writeObject(sentDir == null ? "" : sentDir);
            oos.writeObject(msg.getAttributes());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Pending info file written to:" + pendingInfoFile + "\n\tOriginal MIC: " + msg.getCalculatedMIC() + "\n\tRetry Count: " + retries + "\n\tOriginal file name : " + msg.getAttribute("filename") + "\n\tPending message file : " + pendingFile + "\n\tError directory: " + msg.getAttribute("errordir") + "\n\tSent directory: " + msg.getAttribute("sentdir") + "\n\tAttributes: " + msg.getAttributes() + msg.getLogMsgID()));
            }
            msg.setAttribute("status", "pending");
            if (msg.isConfiguredForAsynchMDN()) {
                // empty if block
            }
        }
        catch (Exception e) {
            msg.setLogMsg("Error setting up pending information files: " + org.openas2.logging.Log.getExceptionMsg(e));
            this.logger.error((Object)msg, (Throwable)e);
            throw new Exception("Unable to set up pending information files.");
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void calcAndStoreMic(Message msg, MimeBodyPart mbp, boolean includeHeaders) throws Exception {
        String mdnOptions = msg.getPartnership().getAttributeOrProperty("as2_mdn_options", null);
        if (mdnOptions == null || mdnOptions.length() < 1) {
            throw new OpenAS2Exception("Partner attribute as2_mdn_optionsis required but can be set to \"none\"");
        }
        if ("none".equalsIgnoreCase(mdnOptions)) {
            return;
        }
        DispositionOptions dispOptions = new DispositionOptions(mdnOptions);
        msg.setCalculatedMIC(AS2Util.getCryptoHelper().calculateMIC(mbp, dispOptions.getMicalg(), includeHeaders, msg.getPartnership().isPreventCanonicalization()));
        if (this.logger.isTraceEnabled()) {
            String tmic = AS2Util.getCryptoHelper().calculateMIC(mbp, dispOptions.getMicalg(), includeHeaders, !msg.getPartnership().isPreventCanonicalization());
            this.logger.trace((Object)("MIC outbound with forced reversed prevent canocalization: " + tmic + msg.getLogMsgID()));
            tmic = AS2Util.getCryptoHelper().calculateMIC(msg.getData(), dispOptions.getMicalg(), false, msg.getPartnership().isPreventCanonicalization());
            this.logger.trace((Object)("MIC outbound with forced exclude headers flag: " + tmic + msg.getLogMsgID()));
        }
    }

    protected void detectFailedSentMessages() {
        File pendingDir;
        String dir;
        try {
            dir = this.getSession().getProcessor().getParameters().get("pendingmdninfo");
        }
        catch (ComponentNotFoundException e) {
            this.logger.warn((Object)"Failed to retrieve the name of the pending info folder for sent messages in trying to run the failed message detection method.", (Throwable)e);
            return;
        }
        try {
            pendingDir = IOUtil.getDirectoryFile(dir);
        }
        catch (IOException e) {
            this.logger.warn((Object)"Failed to open the pending info folder for sent messages in trying to run the failed message detection method.", (Throwable)e);
            return;
        }
        int maxWaitMdnResponseSecs = Integer.parseInt(Properties.getProperty("as2_mdn_response_max_wait_seconds", "4560"));
        long cutoff = System.currentTimeMillis() - (long)(maxWaitMdnResponseSecs * 1000);
        String[] files = pendingDir.list((FilenameFilter)new AgeFileFilter(cutoff));
        for (int i = 0; i < files.length; ++i) {
            File inFile = new File(pendingDir + File.separator + files[i]);
            try {
                AS2Message msg = new AS2Message();
                AS2Util.getMetaData(msg, inFile);
                AS2Util.cleanupFiles(msg, true);
                String msgStr = "Pending information file detected that is past max wait time, Failure most likely due to not receiving MDN response in Async mode: " + inFile.getAbsolutePath();
                msg.setLogMsg(msgStr);
                msg.setStatus("terminated_in_error");
                this.logger.error((Object)msg, null);
                msg.setOption("STATE", "mdn_asyn_receive_fail");
                msg.trackMsgState(this.getSession());
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)"Failed to process the pending info folder for sent messages in trying to run the failed message detection method.", (Throwable)e);
            }
        }
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        String delayStr = Properties.getProperty("as2_mdn_response_max_wait_seconds", "4560");
        Long delay = Long.parseLong(delayStr) / 4L * 1000L;
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AS2SenderModule.this.detectFailedSentMessages();
            }
        }, delay, delay, TimeUnit.MILLISECONDS);
    }
}

