/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.receiver;

import java.io.IOException;
import java.net.Socket;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.message.AS2Message;
import org.openas2.message.AS2MessageMDN;
import org.openas2.processor.receiver.AS2MDNReceiverModule;
import org.openas2.processor.receiver.NetModule;
import org.openas2.processor.receiver.NetModuleHandler;
import org.openas2.util.AS2Util;
import org.openas2.util.ByteArrayDataSource;
import org.openas2.util.HTTPUtil;

public class AS2MDNReceiverHandler
implements NetModuleHandler {
    private AS2MDNReceiverModule module;
    private Log logger = LogFactory.getLog((String)AS2MDNReceiverHandler.class.getSimpleName());

    public AS2MDNReceiverHandler(AS2MDNReceiverModule module) {
        this.module = module;
    }

    public String getClientInfo(Socket s) {
        return " " + s.getInetAddress().getHostAddress() + " " + s.getPort();
    }

    public AS2MDNReceiverModule getModule() {
        return this.module;
    }

    @Override
    public void handle(NetModule owner, Socket s) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("incoming connection [" + this.getClientInfo(s) + "]"));
        }
        AS2Message msg = new AS2Message();
        msg.setOption("DIRECTION", "SEND");
        byte[] data = null;
        try {
            data = HTTPUtil.readData(s.getInputStream(), s.getOutputStream(), msg);
            if (data == null) {
                if ("true".equalsIgnoreCase(msg.getAttribute("isHealthCheck"))) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Healthcheck ping detected [" + this.getClientInfo(s) + "]" + msg.getLogMsgID()));
                    }
                    return;
                }
                try {
                    HTTPUtil.sendHTTPResponse(s.getOutputStream(), 400, null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                OpenAS2Exception oe = new OpenAS2Exception("Missing data in MDN response message");
                msg.setLogMsg("Error receiving asynchronous MDN. There is no data.");
                this.logger.error((Object)msg, (Throwable)oe);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("incoming connection for receiving AsyncMDN [" + this.getClientInfo(s) + "]" + msg.getLogMsgID()));
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Incoming ASYNC MDN message - Message struct: " + msg.toString()));
            }
            MimeBodyPart receivedPart = new MimeBodyPart(msg.getHeaders(), data);
            ContentType receivedContentType = new ContentType(receivedPart.getContentType());
            receivedPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, receivedContentType.toString(), null)));
            receivedPart.setHeader("Content-Type", receivedContentType.toString());
            msg.setData(receivedPart);
            String to = msg.getHeader("AS2-To");
            msg.setHeader("AS2-To", msg.getHeader("AS2-From"));
            msg.setHeader("AS2-From", to);
            msg.getPartnership().setSenderID("as2_id", msg.getHeader("AS2-From"));
            msg.getPartnership().setReceiverID("as2_id", msg.getHeader("AS2-To"));
            this.getModule().getSession().getPartnershipFactory().updatePartnership(msg, true);
            AS2MessageMDN mdn = new AS2MessageMDN(msg, true);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Incoming ASYNC MDN message - MDN struct: " + ((Object)mdn).toString()));
            }
            AS2Util.processMDN(msg, data, s.getOutputStream(), true, this.getModule().getSession(), this);
            msg.setOption("STATE", "msg_sent_mdn_received_ok");
            msg.trackMsgState(this.getModule().getSession());
        }
        catch (Exception e) {
            if ("init_processing_mdn".equals(msg.getStatus()) || "parsing_mdn".equals(msg.getStatus()) || !(e instanceof OpenAS2Exception)) {
                try {
                    HTTPUtil.sendHTTPResponse(s.getOutputStream(), 400, null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                msg.setLogMsg("Unhandled error condition receiving asynchronous MDN. Message and asociated files cleanup will be attempted but may be in an unknown state.");
                this.logger.error((Object)msg, (Throwable)e);
            } else {
                try {
                    HTTPUtil.sendHTTPResponse(s.getOutputStream(), 200, null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                msg.setLogMsg("Exception receiving asynchronous MDN. Message and asociated files cleanup will be attempted but may be in an unknown state.");
                this.logger.error((Object)msg, (Throwable)e);
            }
            msg.setOption("STATE", "msg_send_fail");
            msg.trackMsgState(this.getModule().getSession());
            AS2Util.cleanupFiles(msg, true);
        }
    }
}

