/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.partner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openas2.BaseComponent;
import org.openas2.OpenAS2Exception;
import org.openas2.message.Message;
import org.openas2.message.MessageMDN;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.partner.Partnership;
import org.openas2.partner.PartnershipFactory;
import org.openas2.partner.PartnershipNotFoundException;

public abstract class BasePartnershipFactory
extends BaseComponent
implements PartnershipFactory {
    private List<Partnership> partnerships;

    @Override
    public Partnership getPartnership(Partnership p, boolean reverseLookup) throws OpenAS2Exception {
        Partnership ps;
        Partnership partnership = ps = p.getName() == null ? null : this.getPartnership(p.getName());
        if (ps == null) {
            ps = reverseLookup ? this.getPartnership(p.getReceiverIDs(), p.getSenderIDs()) : this.getPartnership(p.getSenderIDs(), p.getReceiverIDs());
        }
        if (ps == null) {
            throw new PartnershipNotFoundException(p);
        }
        return ps;
    }

    @Override
    public void setPartnerships(List<Partnership> list) {
        this.partnerships = list;
    }

    @Override
    public List<Partnership> getPartnerships() {
        if (this.partnerships == null) {
            this.partnerships = new ArrayList<Partnership>();
        }
        return this.partnerships;
    }

    @Override
    public void updatePartnership(Message msg, boolean overwrite) throws OpenAS2Exception {
        String subject;
        Partnership partnership = this.getPartnership(msg.getPartnership(), false);
        msg.getPartnership().copy(partnership);
        this.processFilenameBasedAttribs(msg);
        if (overwrite && (subject = partnership.getAttribute("subject")) != null) {
            msg.setSubject(ParameterParser.parse(subject, new MessageParameters(msg)));
        }
    }

    public void processFilenameBasedAttribs(Message msg) throws OpenAS2Exception {
        String filename = msg.getAttribute("filename");
        if (filename == null && (filename = msg.getPayloadFilename()) == null) {
            return;
        }
        String filenameToParmsList = msg.getPartnership().getAttribute("attribute_names_from_filename");
        if (filenameToParmsList == null || filenameToParmsList.length() < 1) {
            return;
        }
        String regex = msg.getPartnership().getAttribute("attribute_values_regex_on_filename");
        if (regex == null) {
            return;
        }
        String[] headerNames = filenameToParmsList.split("\\s*,\\s*");
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(filename);
        if (!m.find() || m.groupCount() != headerNames.length) {
            throw new OpenAS2Exception("Could not match filename (" + filename + ") to parameters required using the regex provided (" + regex + "): " + (m.find() ? "Mismatch in parameter count to extracted group count: " + headerNames.length + "::" + m.groupCount() : "No match found in filename"));
        }
        for (int i = 0; i < headerNames.length; ++i) {
            msg.setAttribute(headerNames[i], m.group(i + 1));
        }
    }

    @Override
    public void updatePartnership(MessageMDN mdn, boolean processFilenameAttribs) throws OpenAS2Exception {
        Partnership partnership = this.getPartnership(mdn.getPartnership(), true);
        mdn.getPartnership().copy(partnership);
        if (processFilenameAttribs) {
            this.processFilenameBasedAttribs(mdn.getMessage());
        }
    }

    protected Partnership getPartnership(Map<String, Object> senderIDs, Map<String, Object> receiverIDs) {
        for (Partnership currentPs : this.getPartnerships()) {
            Map<String, Object> currentSids = currentPs.getSenderIDs();
            Map<String, Object> currentRids = currentPs.getReceiverIDs();
            if (!this.compareMap(senderIDs, currentSids) || !this.compareMap(receiverIDs, currentRids)) continue;
            return currentPs;
        }
        return null;
    }

    protected Partnership getPartnership(List<?> partnerships, String name) {
        for (Partnership currentPs : partnerships) {
            String currentName = currentPs.getName();
            if (currentName == null || !currentName.equals(name)) continue;
            return currentPs;
        }
        return null;
    }

    protected Partnership getPartnership(String name) throws OpenAS2Exception {
        return this.getPartnership(this.getPartnerships(), name);
    }

    protected boolean compareMap(Map<String, Object> searchIds, Map<String, Object> partnerIds) {
        Iterator<Map.Entry<String, Object>> searchIt = searchIds.entrySet().iterator();
        if (!searchIt.hasNext()) {
            return false;
        }
        while (searchIt.hasNext()) {
            Map.Entry<String, Object> searchEntry = searchIt.next();
            String searchKey = searchEntry.getKey();
            Object searchValue = searchEntry.getValue();
            Object partnerValue = partnerIds.get(searchKey);
            if (searchValue == null && partnerValue != null) {
                return false;
            }
            if (searchValue != null && partnerValue == null) {
                return false;
            }
            if (searchValue.equals(partnerValue)) continue;
            return false;
        }
        return true;
    }
}

