/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.params;

import java.util.StringTokenizer;
import javax.mail.internet.ParseException;
import org.apache.commons.logging.LogFactory;
import org.openas2.logging.Log;
import org.openas2.message.Message;
import org.openas2.params.CompositeParameters;
import org.openas2.params.DateParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.ParameterParser;
import org.openas2.params.RandomParameters;
import org.openas2.util.Properties;

public class MessageParameters
extends ParameterParser {
    public static final String KEY_SENDER = "sender";
    public static final String KEY_RECEIVER = "receiver";
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HEADERS = "headers";
    public static final String KEY_CONTENT_FILENAME = "content-disposition";
    private Message target;
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)MessageParameters.class.getSimpleName());

    public MessageParameters(Message target) {
        this.target = target;
    }

    @Override
    public void setParameter(String key, String value) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        if (keyParts.countTokens() != 2) {
            throw new InvalidParameterException("Invalid key format", this, key, null);
        }
        String area = keyParts.nextToken();
        String areaID = keyParts.nextToken();
        if (area.equals(KEY_SENDER)) {
            this.getTarget().getPartnership().setSenderID(areaID, value);
        } else if (area.equals(KEY_RECEIVER)) {
            this.getTarget().getPartnership().setReceiverID(areaID, value);
        } else if (area.equals(KEY_ATTRIBUTES)) {
            this.getTarget().setAttribute(areaID, value);
        } else if (area.equals(KEY_HEADERS)) {
            this.getTarget().setHeader(areaID, value);
        } else {
            throw new InvalidParameterException("Invalid area in key", this, key, null);
        }
    }

    @Override
    public String getParameter(String key) throws InvalidParameterException {
        StringTokenizer keyParts = new StringTokenizer(key, ".", false);
        if (keyParts.countTokens() != 2) {
            throw new InvalidParameterException("Invalid key format", this, key, null);
        }
        String area = keyParts.nextToken();
        String areaID = keyParts.nextToken();
        if (area.equals(KEY_SENDER)) {
            return this.getTarget().getPartnership().getSenderID(areaID);
        }
        if (area.equals(KEY_RECEIVER)) {
            return this.getTarget().getPartnership().getReceiverID(areaID);
        }
        if (area.equals(KEY_ATTRIBUTES)) {
            return this.getTarget().getAttribute(areaID);
        }
        if (area.equals(KEY_HEADERS)) {
            return this.getTarget().getHeader(areaID);
        }
        if (area.equals(KEY_CONTENT_FILENAME) && areaID.equals("filename")) {
            String s = null;
            try {
                s = this.getTarget().extractPayloadFilename();
            }
            catch (ParseException e) {
                this.logger.warn((Object)("Failed to extract filename from content-disposition: " + Log.getExceptionMsg(e)), (Throwable)e);
            }
            if (s == null || s.length() < 1) {
                s = this.getTarget().getPayloadFilename();
            }
            if (s != null && s.length() > 0) {
                return s;
            }
            String filename = Properties.getProperty("as2_receive_message_filename_fallback", null);
            if (filename == null) {
                return this.getTarget().getMessageID();
            }
            CompositeParameters parser = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(this.getTarget())).add("rand", new RandomParameters());
            return ParameterParser.parse(filename, parser);
        }
        throw new InvalidParameterException("Invalid area in key", this, key, null);
    }

    public void setTarget(Message message) {
        this.target = message;
    }

    public Message getTarget() {
        return this.target;
    }
}

