/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.openas2.logging.ConsoleLogger;
import org.openas2.logging.Level;
import org.openas2.logging.Logger;
import org.openas2.message.Message;

public class LogManager {
    private static final ConsoleLogger DEFAULT_LOGGER = new ConsoleLogger();
    private static boolean registeredWithApache = false;
    private final List<String> requestors = Collections.synchronizedList(new ArrayList());
    private List<Logger> loggers = Collections.synchronizedList(new ArrayList());

    public static LogManager getLogManager() {
        return DefaultManager.INSTANCE;
    }

    public static boolean isRegisteredWithApache() {
        return registeredWithApache;
    }

    public void setLoggers(List<Logger> listeners) {
        this.loggers = listeners;
    }

    public void addLogger(Logger logger) {
        this.loggers.add(logger);
    }

    public void log(@Nonnull Throwable e, boolean terminated) {
        if (this.loggers.isEmpty()) {
            DEFAULT_LOGGER.log(e, Level.ERROR, terminated);
        } else {
            for (Logger logger : this.loggers) {
                logger.log(e, Level.ERROR, terminated);
            }
        }
    }

    public void log(Level level, String clazzName, @Nonnull Object msg, Throwable t) {
        if (this.loggers.isEmpty()) {
            DEFAULT_LOGGER.log(level, clazzName + ": " + msg.toString(), null, t);
        } else {
            for (Logger logger : this.loggers) {
                if (msg instanceof Message) {
                    logger.log(level, clazzName + ": " + ((Message)msg).getLogMsg(), (Message)msg, t);
                    continue;
                }
                logger.log(level, clazzName + ": " + msg.toString(), null, t);
            }
        }
    }

    void addRequestors(String inName) {
        this.requestors.add(inName);
        registeredWithApache = true;
    }

    private static class DefaultManager {
        private static final LogManager INSTANCE = new LogManager();

        private DefaultManager() {
        }
    }
}

