/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor.restapi;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class CORSFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getHeaderString("Origin") == null) {
            return;
        }
        MultivaluedMap headers = responseContext.getHeaders();
        headers.add((Object)"Access-Control-Allow-Origin", (Object)requestContext.getHeaderString("Origin"));
        if (this.isPreflightRequest(requestContext)) {
            headers.add((Object)"Access-Control-Allow-Credentials", (Object)true);
            headers.add((Object)"Access-Control-Allow-Headers", (Object)"X-Requested-With, Content-Type, Authorization");
            headers.add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, DELETE, PUT, OPTIONS");
            headers.add((Object)"Access-Control-Max-Age", (Object)86400);
            headers.add((Object)"Vary", (Object)"Accept-Encoding, Origin");
            responseContext.setStatus(200);
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.isPreflightRequest(requestContext)) {
            requestContext.abortWith(Response.ok().build());
        }
    }

    private boolean isPreflightRequest(ContainerRequestContext request) {
        return request.getHeaderString("Origin") != null && request.getMethod().equalsIgnoreCase("OPTIONS");
    }
}

