/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app.partner;

import java.util.Iterator;
import org.openas2.OpenAS2Exception;
import org.openas2.app.partner.AliasedPartnershipsCommand;
import org.openas2.cmd.CommandResult;
import org.openas2.partner.Partnership;
import org.openas2.partner.PartnershipFactory;

public class DeletePartnerCommand
extends AliasedPartnershipsCommand {
    @Override
    public String getDefaultDescription() {
        return "Delete the partnership associated with an name.";
    }

    @Override
    public String getDefaultName() {
        return "delete";
    }

    @Override
    public String getDefaultUsage() {
        return "delete <name>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PartnershipFactory partFx, Object[] params) throws OpenAS2Exception {
        if (params.length < 1) {
            return new CommandResult("INVALID PARAMETER COUNT", this.getUsage());
        }
        PartnershipFactory partnershipFactory = partFx;
        synchronized (partnershipFactory) {
            String name = params[0].toString();
            Iterator<String> parts = partFx.getPartners().keySet().iterator();
            boolean found = false;
            while (parts.hasNext()) {
                String partName = parts.next();
                if (!partName.equals(name)) continue;
                found = true;
            }
            if (!found) {
                return new CommandResult("ERROR", "Unknown partner name");
            }
            Iterator<Partnership> partnerships = partFx.getPartnerships().iterator();
            boolean partnershipFound = false;
            while (partnerships.hasNext() && !partnershipFound) {
                Partnership part = partnerships.next();
                partnershipFound = part.getReceiverIDs().containsValue(name) || part.getSenderIDs().containsValue(name);
            }
            if (partnershipFound) {
                return new CommandResult("ERROR", "Can not delete partner; it is tied to some partnerships");
            }
            partFx.getPartners().remove(name);
            return new CommandResult("OK");
        }
    }
}

